/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.impl;

import java.util.HashMap;
import java.util.Map;
import pt.webdetails.cpf.session.IUserSession;

public class SimpleUserSession
implements IUserSession {
    private String userName;
    private String[] authorities;
    private boolean isAdministrator;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public SimpleUserSession(String username, String[] authorities, boolean isAdministrator, Map<String, Object> attributes) {
        this.userName = username;
        this.authorities = authorities;
        this.isAdministrator = isAdministrator;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public SimpleUserSession() {
        this.isAdministrator = false;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    @Override
    public String[] getAuthorities() {
        return this.authorities;
    }

    @Override
    public Object getParameter(String key) {
        if (this.attributes.containsKey(key)) {
            return this.attributes.get(key);
        }
        return null;
    }

    @Override
    public String getStringParameter(String key) {
        Object val = this.getParameter(key);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    @Override
    public void setParameter(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setAuthorities(String[] authorities) {
        this.authorities = authorities;
    }

    public void setAdministrator(boolean isAdministrator) {
        this.isAdministrator = isAdministrator;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}

