/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.dependencies;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public class CssUrlReplacer {
    private static final Pattern thyOldeIEUrl = Pattern.compile("(progid:DXImageTransform.Microsoft.AlphaImageLoader\\(src=')");
    private static final Pattern CSS_URL = Pattern.compile("([^\\w]url\\s*\\(['\"]?)([^\\)\"']*)");
    private static final Pattern URL_PROTOCOL = Pattern.compile("^\\w*\\:");

    private String replaceUrls(String fileContents, String newLocation) {
        Matcher urlMatch = CSS_URL.matcher(fileContents);
        StringBuffer sb = new StringBuffer();
        while (urlMatch.find()) {
            String url = urlMatch.group(2);
            if (URL_PROTOCOL.matcher(url).find() || url.startsWith("/")) {
                urlMatch.appendReplacement(sb, urlMatch.group());
                continue;
            }
            String firstPart = urlMatch.group(1);
            urlMatch.appendReplacement(sb, firstPart);
            sb.append(newLocation);
            sb.append(url);
        }
        urlMatch.appendTail(sb);
        String replacedContents = this.makeSillyIEReplacement(newLocation, sb.toString());
        return replacedContents;
    }

    private String makeSillyIEReplacement(String newLocation, String replacedContents) {
        String replacement = RepositoryHelper.appendPath(newLocation, "../");
        replacedContents = thyOldeIEUrl.matcher(replacedContents).replaceAll("$1" + replacement);
        return replacedContents;
    }

    public String processContents(String fileContents, String location) {
        return this.replaceUrls(fileContents, location);
    }
}

