/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.openerp;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.reporting.di.OpenERPConfiguration;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPFilterInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.util.Base64;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;

public class OpenERPDataFactory
extends AbstractDataFactory {
    private static final long serialVersionUID = -6235833289788633577L;
    private static final Log logger = LogFactory.getLog(OpenERPDataFactory.class);
    private OpenERPConfiguration config;
    private String queryName;

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queryName.equals(query);
    }

    public String[] getQueryNames() {
        return new String[]{this.queryName};
    }

    public synchronized TableModel queryData(String query, final DataRow parameters) throws ReportDataFactoryException {
        Object[][] rows;
        if (this.config == null) {
            throw new ReportDataFactoryException("Configuration is empty.");
        }
        TypedTableModel resultSet = new TypedTableModel();
        int queryLimit = this.calculateQueryLimit(parameters);
        OpenERPHelper helper = new OpenERPHelper();
        OpenERPConfiguration targetConfig = this.config.clone();
        ArrayList configFilters = targetConfig.getFilters();
        HashMap<String, Object> openERPParams = new HashMap<String, Object>();
        for (String paramName : parameters.getColumnNames()) {
            Object value = parameters.get(paramName);
            if (value == null) {
                value = false;
            }
            openERPParams.put(paramName, value);
        }
        ArrayList selectedFields = null;
        try {
            selectedFields = helper.getFields(targetConfig, openERPParams);
        }
        catch (Exception e1) {
            throw new ReportDataFactoryException("Failed to select field", (Throwable)e1);
        }
        for (OpenERPFieldInfo selectedFld : selectedFields) {
            resultSet.addColumn(selectedFld.getRenamedFieldName(), this.convertFieldType(selectedFld.getFieldType()));
        }
        if (queryLimit == 1) {
            return resultSet;
        }
        PropertyLookupParser parameterParser = new PropertyLookupParser(){
            private static final long serialVersionUID = -7264648195698966110L;

            protected String lookupVariable(String property) {
                return parameters.get(property).toString();
            }
        };
        if (configFilters != null) {
            for (OpenERPFilterInfo filter : configFilters) {
                if (!(filter.getValue() instanceof String)) continue;
                try {
                    Object filterValue;
                    String realFilterValue = filter.getValue().toString();
                    if (realFilterValue.length() >= 4 && realFilterValue.substring(0, 2).equals("${") && realFilterValue.endsWith("}")) {
                        String parameterName = realFilterValue.substring(2, realFilterValue.length() - 1);
                        filterValue = parameters.get(parameterName);
                    } else {
                        filterValue = parameterParser.translateAndLookup(realFilterValue, parameters);
                    }
                    if (filterValue == null) {
                        return resultSet;
                    }
                    filter.setValue(filterValue);
                }
                catch (Exception e) {
                    throw new ReportDataFactoryException(e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            rows = helper.getData(targetConfig, openERPParams);
        }
        catch (Exception e) {
            throw new ReportDataFactoryException(e.getMessage(), (Throwable)e);
        }
        for (int row = 0; row < rows.length; ++row) {
            Object[] rowData = rows[row];
            for (int column = 0; column < selectedFields.size(); ++column) {
                OpenERPFieldInfo fld = (OpenERPFieldInfo)selectedFields.get(column);
                if (fld.getFieldType() == Field.FieldType.BINARY && rowData[column] != null) {
                    try {
                        rowData[column] = Base64.decode((String)rowData[column].toString());
                    }
                    catch (Base64.DecodingException e) {
                        rowData[column] = "Unable to decode string";
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Failed to decode string on query-result: Row=" + row + " Col=" + column), (Throwable)e);
                    }
                }
                if (fld.getFieldType() == Field.FieldType.MANY2ONE && rowData[column] instanceof Object[]) {
                    Object[] value = (Object[])rowData[column];
                    rowData[column] = Integer.parseInt(String.valueOf(value[0]));
                }
                if (fld.getFieldType() != Field.FieldType.MANY2MANY && fld.getFieldType() != Field.FieldType.ONE2MANY || !(rowData[column] instanceof Object[])) continue;
                StringBuilder stringValue = new StringBuilder();
                Object[] mcolumn = (Object[])rowData[column];
                for (int x = 0; x < mcolumn.length; ++x) {
                    if (x != 0) {
                        stringValue.append(',');
                    }
                    stringValue.append(mcolumn[x]);
                }
                rowData[column] = stringValue.toString();
            }
            resultSet.addRow(rowData);
        }
        return resultSet;
    }

    private Class<?> convertFieldType(Field.FieldType fieldType) {
        switch (fieldType) {
            case BINARY: {
                return Byte[].class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DATETIME: 
            case DATE: {
                return Date.class;
            }
            case MANY2ONE: {
                return Integer.class;
            }
        }
        return String.class;
    }

    public void setConfig(OpenERPConfiguration config) {
        this.config = config;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void close() {
    }

    public OpenERPDataFactory clone() {
        OpenERPDataFactory dataFactory = (OpenERPDataFactory)super.clone();
        if (this.config != null) {
            dataFactory.config = this.config.clone();
        }
        return dataFactory;
    }

    public OpenERPConfiguration getConfig() {
        return this.config;
    }
}

