/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.util.HashMap;
import javax.transaction.xa.XAException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.jdbc.EmbedXAResource;

final class XATransactionState
extends ContextImpl {
    static final int TRO_DEADLOCK = -2;
    static final int TRO_FAIL = -1;
    static final int T0_NOT_ASSOCIATED = 0;
    static final int T1_ASSOCIATED = 1;
    static final int TC_COMPLETED = 3;
    final EmbedConnection conn;
    final EmbedXAResource creatingResource;
    private EmbedXAResource associatedResource;
    final XAXactId xid;
    HashMap suspendedList;
    int associationState;
    int rollbackOnlyCode;
    boolean isPrepared;

    XATransactionState(ContextManager contextManager, EmbedConnection embedConnection, EmbedXAResource embedXAResource, XAXactId xAXactId) {
        super(contextManager, "XATransactionState");
        this.conn = embedConnection;
        this.associatedResource = embedXAResource;
        this.creatingResource = embedXAResource;
        this.associationState = 1;
        this.xid = xAXactId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupOnError(Throwable throwable) {
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            if (standardException.getSeverity() >= 40000) {
                this.popMe();
                return;
            }
            if (standardException.getSeverity() == 30000) {
                XATransactionState xATransactionState = this;
                synchronized (xATransactionState) {
                    this.conn.setApplicationConnection(null);
                    this.notifyAll();
                    this.associationState = -1;
                    this.rollbackOnlyCode = "40001".equals(standardException.getMessageId()) ? 102 : ("40XL1".equals(standardException.getMessageId()) ? 106 : 104);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(EmbedXAResource embedXAResource, int n) throws XAException {
        XATransactionState xATransactionState = this;
        synchronized (xATransactionState) {
            boolean bl;
            if (this.associationState == -1) {
                throw new XAException(this.rollbackOnlyCode);
            }
            boolean bl2 = bl = this.suspendedList != null && this.suspendedList.get(embedXAResource) != null;
            if (n == 0x8000000 ? !bl : bl) {
                throw new XAException(-6);
            }
            while (this.associationState == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new XAException(4);
                }
            }
            switch (this.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(this.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-4);
                }
            }
            if (this.isPrepared) {
                throw new XAException(-6);
            }
            if (bl) {
                this.suspendedList.remove(embedXAResource);
            }
            this.associationState = 1;
            this.associatedResource = embedXAResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean end(EmbedXAResource embedXAResource, int n, boolean bl) throws XAException {
        boolean bl2 = false;
        XATransactionState xATransactionState = this;
        synchronized (xATransactionState) {
            boolean bl3;
            boolean bl4 = bl3 = this.suspendedList != null && this.suspendedList.get(embedXAResource) != null;
            if (!bl) {
                while (this.associationState == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new XAException(4);
                    }
                }
            }
            switch (this.associationState) {
                case 3: {
                    throw new XAException(-4);
                }
                case -1: {
                    if (bl) {
                        n = 0x20000000;
                        break;
                    }
                    throw new XAException(this.rollbackOnlyCode);
                }
            }
            boolean bl5 = false;
            switch (n) {
                case 0x4000000: {
                    if (bl3) {
                        this.suspendedList.remove(embedXAResource);
                    } else {
                        if (embedXAResource != this.associatedResource) {
                            throw new XAException(-6);
                        }
                        this.associationState = 0;
                        this.associatedResource = null;
                        bl5 = true;
                    }
                    this.conn.setApplicationConnection(null);
                    break;
                }
                case 0x20000000: {
                    if (bl3) {
                        this.suspendedList.remove(embedXAResource);
                    } else {
                        if (embedXAResource != this.associatedResource) {
                            throw new XAException(-6);
                        }
                        this.associatedResource = null;
                    }
                    if (this.associationState != -1) {
                        this.associationState = -1;
                        this.rollbackOnlyCode = 100;
                    }
                    this.conn.setApplicationConnection(null);
                    bl5 = true;
                    bl2 = true;
                    break;
                }
                case 0x2000000: {
                    if (bl3) {
                        throw new XAException(-6);
                    }
                    if (embedXAResource != this.associatedResource) {
                        throw new XAException(-6);
                    }
                    if (this.suspendedList == null) {
                        this.suspendedList = new HashMap();
                    }
                    this.suspendedList.put(embedXAResource, this);
                    this.associationState = 0;
                    this.associatedResource = null;
                    this.conn.setApplicationConnection(null);
                    bl5 = true;
                    break;
                }
                default: {
                    throw new XAException(-5);
                }
            }
            if (bl5) {
                this.notifyAll();
            }
            return bl2;
        }
    }
}

