/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.openerp.objectoutput;

import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.FilterCollection;
import com.debortoliwines.openerp.api.ObjectAdapter;
import com.debortoliwines.openerp.api.OpeneERPApiException;
import com.debortoliwines.openerp.api.Row;
import com.debortoliwines.openerp.api.RowCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xmlrpc.XmlRpcException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.openerp.core.OpenERPHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.openerp.objectoutput.OpenERPObjectOutputData;
import org.pentaho.di.trans.steps.openerp.objectoutput.OpenERPObjectOutputMeta;

public class OpenERPObjectOutput
extends BaseStep
implements StepInterface {
    private OpenERPObjectOutputMeta meta;
    private OpenERPObjectOutputData data;
    ObjectAdapter openerERPAdapter;
    private int idIndex = -1;
    private int[] index;
    private FilterCollection readSourceFilter;
    private ArrayList<String> readFieldList = new ArrayList();
    private int[] readRowIndex = new int[0];
    private HashMap<String, Object> filterRowCache = new HashMap();
    private final String SEPARATOR = "A|a";
    private FieldCollection rowFields;

    public OpenERPObjectOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] inputRow = this.getRow();
        if (inputRow == null) {
            try {
                this.CommitBatch();
            }
            catch (Exception e) {
                throw new KettleException("Failed to commit batch: ", (Throwable)e);
            }
            this.logDebug("No More Rows.");
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            try {
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                this.prepareFieldList();
                if (this.idIndex == -1 && this.meta.getKeyLookups().size() > 0) {
                    this.prepareReadParameters();
                    this.prepareCache();
                }
                this.rowFields = this.openerERPAdapter.getFields(this.meta.getModelFields());
            }
            catch (Exception e) {
                throw new KettleException("Failed to initialize step ", (Throwable)e);
            }
            this.first = false;
            this.data.updateBatchRows.clear();
        }
        Object[] outputRow = new Object[this.data.outputRowMeta.size()];
        for (int i = 0; i < this.getInputRowMeta().size(); ++i) {
            outputRow[i] = inputRow[i];
        }
        String row = "";
        try {
            Row updateRow = this.openerERPAdapter.getNewRow(this.rowFields);
            if (this.idIndex >= 0) {
                updateRow.put("id", this.getInputValue(inputRow, this.idIndex));
            } else {
                String combinedKey = "";
                for (int i : this.readRowIndex) {
                    combinedKey = combinedKey + "A|a" + (inputRow[i] == null ? "" : this.getInputValue(inputRow, i));
                }
                if (this.filterRowCache.containsKey(combinedKey)) {
                    updateRow.put("id", this.filterRowCache.get(combinedKey));
                } else {
                    updateRow.put("id", (Object)0);
                }
            }
            for (int i = 0; i < this.meta.getModelFields().length; ++i) {
                updateRow.put(this.meta.getModelFields()[i], this.getInputValue(inputRow, this.index[i]));
            }
            if (!this.data.helper.getImportReturnIDS() && this.meta.getOutputIDField() && updateRow.getID() == 0) {
                this.openerERPAdapter.createObject(updateRow);
                outputRow[this.data.outputRowMeta.indexOfValue((String)this.meta.getOutputIDFieldName())] = Long.parseLong(updateRow.get("id").toString());
                this.incrementLinesOutput();
                this.putRow(this.data.outputRowMeta, outputRow);
            } else {
                if (!this.data.helper.getImportReturnIDS() && this.meta.getOutputIDField()) {
                    outputRow[this.data.outputRowMeta.indexOfValue((String)this.meta.getOutputIDFieldName())] = Long.parseLong(updateRow.get("id").toString());
                }
                this.data.updateBatchRows.add(updateRow);
                this.data.outputBatchRows.add(outputRow);
                if (this.data.updateBatchRows.size() == this.meta.getCommitBatchSize()) {
                    this.CommitBatch();
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Failed to commit batch: " + row, (Throwable)e);
        }
        return true;
    }

    private Object getInputValue(Object[] inputRow, int index) throws KettleValueException {
        return this.getInputRowMeta().getValueMeta(index).convertToNormalStorageType(inputRow[index]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CommitBatch() throws Exception {
        if (this.isStopped() || this.data.updateBatchRows.size() == 0) {
            return;
        }
        try {
            this.openerERPAdapter.importData(this.data.updateBatchRows);
            int idFieldIndex = -1;
            if (this.meta.getOutputIDField()) {
                idFieldIndex = this.data.outputRowMeta.indexOfValue(this.meta.getOutputIDFieldName());
            }
            for (int i = 0; i < this.data.updateBatchRows.size(); ++i) {
                this.incrementLinesOutput();
                Object[] outputrow = this.data.outputBatchRows.get(i);
                if (this.data.helper.getImportReturnIDS() && idFieldIndex >= 0) {
                    outputrow[idFieldIndex] = Long.parseLong(((Row)this.data.updateBatchRows.get(i)).get("id").toString());
                }
                this.putRow(this.data.outputRowMeta, outputrow);
            }
        }
        finally {
            this.data.updateBatchRows.clear();
            this.data.outputBatchRows.clear();
        }
    }

    private void prepareCache() throws XmlRpcException, OpeneERPApiException {
        this.filterRowCache.clear();
        RowCollection rows = this.data.helper.getModelData(this.meta.getModelName(), this.readSourceFilter, this.readFieldList.toArray(new String[this.readFieldList.size()]));
        for (Row row : rows) {
            String combinedKey = "";
            for (String fieldname : this.readFieldList) {
                Object value = row.get(fieldname);
                if (value instanceof Object[]) {
                    value = ((Object[])value)[0];
                }
                combinedKey = combinedKey + "A|a" + (value == null ? "" : value);
            }
            this.filterRowCache.put(combinedKey, row.get("id"));
        }
    }

    private void prepareReadParameters() throws Exception {
        int i;
        ArrayList<Integer> readIdx = new ArrayList<Integer>();
        this.readSourceFilter = new FilterCollection();
        for (i = 0; i < this.meta.getKeyLookups().size(); ++i) {
            String modelField = this.meta.getKeyLookups().get(i)[0];
            String comparison = this.meta.getKeyLookups().get(i)[1];
            String streamField = this.meta.getKeyLookups().get(i)[2];
            if (streamField != null && streamField.length() > 0 && this.getInputRowMeta().indexOfValue(streamField) >= 0) {
                this.readFieldList.add(modelField);
                readIdx.add(this.getInputRowMeta().indexOfValue(streamField));
                continue;
            }
            this.readSourceFilter.add(modelField, comparison, (Object)streamField);
            this.logBasic("Setting filter: [" + modelField + "," + comparison + "," + streamField + "]");
        }
        this.readRowIndex = new int[readIdx.size()];
        for (i = 0; i < this.readRowIndex.length; ++i) {
            this.readRowIndex[i] = (Integer)readIdx.get(i);
        }
    }

    private void prepareFieldList() throws Exception {
        if (this.meta.getKeyLookups().size() == 1 && this.meta.getKeyLookups().get(0)[0] != null && this.meta.getKeyLookups().get(0)[1] != null && this.meta.getKeyLookups().get(0)[2] != null && this.meta.getKeyLookups().get(0)[0].equals("id") && this.meta.getKeyLookups().get(0)[1].equals("=")) {
            this.idIndex = this.getInputRowMeta().indexOfValue(this.meta.getKeyLookups().get(0)[2]);
        }
        this.index = new int[this.meta.getModelFields().length];
        for (int i = 0; i < this.meta.getModelFields().length; ++i) {
            this.index[i] = this.getInputRowMeta().indexOfValue(this.meta.getStreamFields()[i]);
            if (this.index[i] >= 0) continue;
            throw new KettleException("Stream field not found", (Throwable)new Exception("Could not find stream field: " + this.meta.getStreamFields()[i]));
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (OpenERPObjectOutputMeta)smi;
        this.data = (OpenERPObjectOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.logDebug("Initializing OpenERP Session");
                this.data.helper = new OpenERPHelper(this.meta.getDatabaseMeta());
                this.data.helper.StartSession();
                this.openerERPAdapter = this.data.helper.getAdapter(this.meta.getModelName());
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

