/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.agilebi.modeler.models.annotations.data.ColumnMapping;
import org.pentaho.agilebi.modeler.models.annotations.data.DataProvider;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.ProvidesModelerMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.build.JobEntryBuildModel;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class DataProviderHelper {
    private final IMetaStore mstore;
    private final ModelAnnotationManager annotationManager = new ModelAnnotationManager(true);
    private static Class<?> PKG = JobEntryBuildModel.class;

    public DataProviderHelper(IMetaStore mstore) {
        this.mstore = mstore;
    }

    protected IMetaStore getMetaStore() {
        return this.mstore;
    }

    protected ModelAnnotationManager getModelAnnotationManager() {
        return this.annotationManager;
    }

    public void updateDataProvider(ModelAnnotationGroup annotations, StepMetaDataCombi outputCombi) throws KettleException, MetaStoreException {
        DataProvider provider = this.createDataProvider(outputCombi, this.mstore);
        this.updateOrAdd(annotations.getDataProviders(), provider);
        this.getModelAnnotationManager().updateGroup(annotations, this.mstore);
    }

    private DataProvider createDataProvider(StepMetaDataCombi outputCombi, IMetaStore mstore) throws KettleException, MetaStoreException {
        DataProvider provider = new DataProvider();
        provider.setName(outputCombi.stepname);
        ProvidesDatabaseConnectionInformation connInfo = (ProvidesDatabaseConnectionInformation)outputCombi.meta;
        DatabaseMeta dbMeta = DataProviderHelper.fillConnectionInfo(provider, connInfo, (VariableSpace)outputCombi.step);
        if (dbMeta.getName().contains("/")) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"BuildModelJob.Error.ConnectionName.InvalidCharacter", (String[])new String[]{dbMeta.getName()}));
        }
        provider.setColumnMappings(DataProviderHelper.getColumnMappings(outputCombi));
        provider.setDatabaseMetaNameRef(this.getModelAnnotationManager().storeDatabaseMeta(dbMeta, mstore));
        return provider;
    }

    private static DatabaseMeta fillConnectionInfo(DataProvider provider, ProvidesDatabaseConnectionInformation connInfo, VariableSpace varSpace) {
        provider.setSchemaName(varSpace.environmentSubstitute(connInfo.getSchemaName()));
        provider.setTableName(varSpace.environmentSubstitute(connInfo.getTableName()));
        DatabaseMeta dbMeta = (DatabaseMeta)connInfo.getDatabaseMeta().clone();
        dbMeta.setHostname(connInfo.getDatabaseMeta().environmentSubstitute(dbMeta.getHostname()));
        dbMeta.setDBName(connInfo.getDatabaseMeta().environmentSubstitute(dbMeta.getDatabaseName()));
        return dbMeta;
    }

    private static List<ColumnMapping> getColumnMappings(StepMetaDataCombi outputStepMetaDataCombi) throws KettleException {
        try {
            OutputStepMappingAdapter adapter = new OutputStepMappingAdapter(outputStepMetaDataCombi);
            HashMap<String, String> metaFieldMap = new HashMap<String, String>(adapter.fieldDatabase.size());
            for (int i = 0; i < adapter.fieldDatabase.size(); ++i) {
                metaFieldMap.put(adapter.fieldDatabase.get(i), adapter.fieldStream.get(i));
            }
            ArrayList<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>();
            if (adapter.insertRowMeta != null) {
                for (ValueMetaInterface valueMeta : adapter.insertRowMeta.getValueMetaList()) {
                    ColumnMapping colMap = new ColumnMapping();
                    colMap.setColumnName(valueMeta.getName());
                    if (metaFieldMap.containsKey(valueMeta.getName())) {
                        colMap.setName((String)metaFieldMap.get(colMap.getColumnName()));
                    } else {
                        colMap.setName(valueMeta.getName());
                    }
                    colMap.setColumnDataType(DataProviderHelper.getDataType(valueMeta));
                    columnMappings.add(colMap);
                }
            }
            return columnMappings;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private static boolean equalsNoColumnMappings(DataProvider one, DataProvider other) {
        return StringUtils.equals((String)one.getDatabaseMetaNameRef(), (String)other.getDatabaseMetaNameRef()) && StringUtils.equals((String)one.getSchemaName(), (String)other.getSchemaName()) && StringUtils.equals((String)one.getTableName(), (String)other.getTableName());
    }

    private DataProvider updateOrAdd(List<DataProvider> annotationProviders, DataProvider newProvider) {
        for (DataProvider dataProvider : annotationProviders) {
            if (!DataProviderHelper.equalsNoColumnMappings(dataProvider, newProvider)) continue;
            dataProvider.setColumnMappings(newProvider.getColumnMappings());
            return dataProvider;
        }
        annotationProviders.add(newProvider);
        return newProvider;
    }

    public static DataType getDataType(ValueMetaInterface valueMeta) {
        switch (valueMeta.getType()) {
            case 1: 
            case 5: 
            case 6: {
                return DataType.NUMERIC;
            }
            case 8: {
                return DataType.BINARY;
            }
            case 4: {
                return DataType.BOOLEAN;
            }
            case 3: {
                return DataType.DATE;
            }
            case 2: {
                return DataType.STRING;
            }
        }
        return DataType.UNKNOWN;
    }

    public static class OutputStepMappingAdapter {
        protected final List<String> fieldDatabase;
        protected final List<String> fieldStream;
        protected final RowMeta insertRowMeta;

        public OutputStepMappingAdapter(StepMetaDataCombi stepMetaDataCombi) throws ModelerException {
            if (!(stepMetaDataCombi.meta instanceof ProvidesModelerMeta)) {
                throw new ModelerException("Step being Annotated is unsupported");
            }
            ProvidesModelerMeta modelerMeta = (ProvidesModelerMeta)stepMetaDataCombi.meta;
            this.insertRowMeta = modelerMeta.getRowMeta(stepMetaDataCombi.data);
            this.fieldDatabase = modelerMeta.getDatabaseFields();
            this.fieldStream = modelerMeta.getStreamFields();
        }
    }
}

