/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KeyedComboBoxModel<K, V>
implements ComboBoxModel {
    private int selectedItemIndex = -1;
    private V selectedItemValue;
    private ArrayList<ComboBoxItemPair<K, V>> data = new ArrayList();
    private ArrayList<ListDataListener> listdatalistener = new ArrayList();
    private transient ListDataListener[] tempListeners;
    private boolean allowOtherValue;

    public KeyedComboBoxModel() {
    }

    public KeyedComboBoxModel(K[] keys, V[] values) {
        this();
        this.setData(keys, values);
    }

    public void setData(K[] keys, V[] values) {
        if (values.length != keys.length) {
            throw new IllegalArgumentException("Values and text must have the same length.");
        }
        this.data.clear();
        this.data.ensureCapacity(keys.length);
        for (int i = 0; i < values.length; ++i) {
            this.add(keys[i], values[i]);
        }
        this.selectedItemIndex = -1;
        ListDataEvent evt = new ListDataEvent(this, 0, 0, this.data.size() - 1);
        this.fireListDataEvent(evt);
    }

    protected synchronized void fireListDataEvent(ListDataEvent evt) {
        if (this.tempListeners == null) {
            this.tempListeners = this.listdatalistener.toArray(new ListDataListener[this.listdatalistener.size()]);
        }
        ListDataListener[] listeners = this.tempListeners;
        for (int i = 0; i < listeners.length; ++i) {
            ListDataListener l = listeners[i];
            l.contentsChanged(evt);
        }
    }

    public V getSelectedItem() {
        return this.selectedItemValue;
    }

    public void setSelectedKey(K anItem) {
        int oldSelectedItem = this.selectedItemIndex;
        int newSelectedItem = this.findDataElementIndex(anItem);
        if (newSelectedItem == -1) {
            this.selectedItemIndex = -1;
            this.selectedItemValue = null;
        } else {
            this.selectedItemIndex = newSelectedItem;
            this.selectedItemValue = this.getElementAt(this.selectedItemIndex);
        }
        if (oldSelectedItem != this.selectedItemIndex) {
            this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
        }
    }

    @Override
    public final void setSelectedItem(Object anItem) {
        this.setSelectedValue(anItem);
    }

    public void setSelectedValue(V anItem) {
        int oldSelectedItem = this.selectedItemIndex;
        int newSelectedItem = this.findElementIndex(anItem);
        if (newSelectedItem == -1) {
            if (this.isAllowOtherValue()) {
                this.selectedItemIndex = -1;
                this.selectedItemValue = anItem;
            } else {
                this.selectedItemIndex = -1;
                this.selectedItemValue = null;
            }
        } else {
            this.selectedItemIndex = newSelectedItem;
            this.selectedItemValue = this.getElementAt(this.selectedItemIndex);
        }
        if (oldSelectedItem != this.selectedItemIndex) {
            this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
        }
    }

    private boolean isAllowOtherValue() {
        return this.allowOtherValue;
    }

    public void setAllowOtherValue(boolean allowOtherValue) {
        this.allowOtherValue = allowOtherValue;
    }

    @Override
    public synchronized void addListDataListener(ListDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.listdatalistener.add(l);
        this.tempListeners = null;
    }

    @Override
    public V getElementAt(int index) {
        if (index == -1 || index >= this.data.size()) {
            return null;
        }
        ComboBoxItemPair<K, V> datacon = this.data.get(index);
        if (datacon == null) {
            return null;
        }
        return datacon.getValue();
    }

    public K getKeyAt(int index) {
        if (index >= this.data.size()) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        ComboBoxItemPair<K, V> datacon = this.data.get(index);
        if (datacon == null) {
            return null;
        }
        return datacon.getKey();
    }

    public K getSelectedKey() {
        return this.getKeyAt(this.selectedItemIndex);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listdatalistener.remove(l);
        this.tempListeners = null;
    }

    private int findDataElementIndex(K anItem) {
        for (int i = 0; i < this.data.size(); ++i) {
            ComboBoxItemPair<K, V> datacon = this.data.get(i);
            K key = datacon.getKey();
            if (anItem == key) {
                return i;
            }
            if (anItem == null || !anItem.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public int findElementIndex(V anItem) {
        for (int i = 0; i < this.data.size(); ++i) {
            ComboBoxItemPair<K, V> datacon = this.data.get(i);
            V value = datacon.getValue();
            if (anItem == value) {
                return i;
            }
            if (anItem == null || !anItem.equals(value)) continue;
            return i;
        }
        return -1;
    }

    public void removeDataElement(K key) {
        int idx = this.findDataElementIndex(key);
        if (idx == -1) {
            return;
        }
        this.data.remove(idx);
        ListDataEvent evt = new ListDataEvent(this, 2, idx, idx);
        this.fireListDataEvent(evt);
    }

    public void add(K key, V cbitem) {
        ComboBoxItemPair con = new ComboBoxItemPair(key, cbitem);
        this.data.add(con);
        ListDataEvent evt = new ListDataEvent(this, 1, this.data.size() - 2, this.data.size() - 2);
        this.fireListDataEvent(evt);
    }

    public void update(int index, K key, V cbitem) {
        ComboBoxItemPair con = new ComboBoxItemPair(key, cbitem);
        this.data.set(index, con);
        ListDataEvent evt = new ListDataEvent(this, 0, index, index);
        this.fireListDataEvent(evt);
    }

    public void clear() {
        int size = this.getSize();
        this.data.clear();
        this.fireListDataEvent(new ListDataEvent(this, 2, 0, size - 1));
        this.selectedItemIndex = -1;
        this.selectedItemValue = null;
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    public int getSelectedItemIndex() {
        return this.selectedItemIndex;
    }

    public void remove(int index) {
        this.data.remove(index);
        ListDataEvent evt = new ListDataEvent(this, 2, index, index);
        this.fireListDataEvent(evt);
    }

    private static class ComboBoxItemPair<K, V> {
        private K key;
        private V value;

        private ComboBoxItemPair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

