/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.background;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;

public class DataPreviewDialog
extends JDialog {
    private JTable table;

    public DataPreviewDialog() throws HeadlessException {
        this.init();
    }

    public DataPreviewDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public DataPreviewDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setTitle(Messages.getInstance().getString("PreviewDialog.Title"));
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.setContentPane(mainPanel);
        this.table = new JTable();
        mainPanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        JButton closeButton = new JButton(new CloseAction());
        buttonsPanel.add(closeButton);
        mainPanel.add((Component)buttonsPanel, "South");
        JComponent contentPane = (JComponent)this.getContentPane();
        InputMap inputMap = contentPane.getInputMap();
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("cancel", new CloseAction());
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
    }

    public void showData(PreviewWorker previewWorker) {
        Thread qt = new Thread(previewWorker);
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog(qt, previewWorker, this, Messages.getInstance().getString("PreviewDialog.PreviewDataTask"));
        TableModel rawTableModel = previewWorker.getResultTableModel();
        if (this.showData(rawTableModel)) {
            return;
        }
        previewWorker.close();
    }

    public boolean showData(TableModel rawTableModel) {
        if (rawTableModel == null) {
            return true;
        }
        LibSwingUtil.centerDialogInParent(this);
        this.table.setModel(rawTableModel);
        this.setVisible(true);
        return false;
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
            this.putValue("Name", Messages.getInstance().getString("PreviewDialog.Close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataPreviewDialog.this.dispose();
        }
    }
}

