/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ExtendedColorModel;

public abstract class AbstractColorChooserPanel
extends JComponent {
    private ExtendedColorModel colorSelectionModel;
    private ColorSelectionListener colorSelectionListener = new ColorSelectionListener();

    protected AbstractColorChooserPanel() {
    }

    public ExtendedColorModel getColorSelectionModel() {
        return this.colorSelectionModel;
    }

    public abstract String getDisplayName();

    public abstract Icon getSmallDisplayIcon();

    public int getMnemonic() {
        return 0;
    }

    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    public void installChooserPanel(ExtendedColorModel colorSelectionModel) {
        if (colorSelectionModel == null) {
            throw new NullPointerException();
        }
        if (this.colorSelectionModel != null) {
            this.colorSelectionModel.removeChangeListener(this.colorSelectionListener);
        }
        this.colorSelectionModel = colorSelectionModel;
        this.colorSelectionModel.addChangeListener(this.colorSelectionListener);
    }

    public void uninstallChooserPanel() {
        if (this.colorSelectionModel != null) {
            this.colorSelectionModel.removeChangeListener(this.colorSelectionListener);
        }
        this.colorSelectionModel = null;
    }

    protected Color getColorFromModel() {
        if (this.colorSelectionModel == null) {
            return null;
        }
        return this.colorSelectionModel.getSelectedColor();
    }

    protected void colorUpdated() {
    }

    private class ColorSelectionListener
    implements ChangeListener {
        private ColorSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractColorChooserPanel.this.colorUpdated();
        }
    }
}

