/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.Collection;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilterImpl;
import org.apache.jackrabbit.core.security.authorization.acl.PentahoEntry;
import org.apache.jackrabbit.core.security.authorization.acl.PentahoEntryFilter;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoEntryFilterImpl
extends EntryFilterImpl
implements PentahoEntryFilter {
    private static final Logger log = LoggerFactory.getLogger(PentahoEntryFilterImpl.class);
    private final Collection<String> principalNames;
    private final PathProvider pathProvider;
    private String itemPath;

    PentahoEntryFilterImpl(Collection<String> principalNames, final ItemId id, final SessionImpl sessionImpl) {
        super(principalNames, id, sessionImpl);
        this.principalNames = principalNames;
        this.pathProvider = new PathProvider(){

            @Override
            public String getPath() throws RepositoryException {
                Path p = sessionImpl.getHierarchyManager().getPath(id);
                return sessionImpl.getJCRPath(p);
            }
        };
    }

    PentahoEntryFilterImpl(Collection<String> principalNames, final Path absPath, final PathResolver pathResolver) {
        super(principalNames, absPath, pathResolver);
        this.principalNames = principalNames;
        this.pathProvider = new PathProvider(){

            @Override
            public String getPath() throws RepositoryException {
                return pathResolver.getJCRPath(absPath);
            }
        };
    }

    public void filterEntries(List entries, List ... resultLists) {
        if (resultLists.length == 2) {
            List userAces = resultLists[0];
            List groupAces = resultLists[1];
            int uInsertIndex = userAces.size();
            int gInsertIndex = groupAces.size();
            for (PentahoEntry ace : entries) {
                if (!this.matches(ace)) continue;
                if (ace.isGroupEntry()) {
                    groupAces.add(gInsertIndex, ace);
                    continue;
                }
                userAces.add(uInsertIndex, ace);
            }
        } else {
            log.warn("Filtering aborted. Expected 2 result lists.");
        }
    }

    private boolean matches(PentahoEntry entry) {
        if (this.principalNames == null || this.principalNames.contains(entry.getPrincipalName())) {
            if (!entry.hasRestrictions()) {
                return true;
            }
            try {
                return entry.matches(this.getPath());
            }
            catch (RepositoryException e) {
                log.error("Cannot determine ACE match.", (Throwable)e);
            }
        }
        return false;
    }

    String getPath() throws RepositoryException {
        if (this.itemPath == null) {
            this.itemPath = this.pathProvider.getPath();
        }
        return this.itemPath;
    }

    private static interface PathProvider {
        public String getPath() throws RepositoryException;
    }
}

