/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

public class DumpToFilePentahoSystemListener
implements IPentahoSystemListener {
    private static final Log logger = LogFactory.getLog(DumpToFilePentahoSystemListener.class);
    public static final String PROP_DUMP_TO_FILE = "pentaho.repository.dumpToFile";
    public static final String PROP_DUMP_TO_FILE_SYSTEM_VIEW = "pentaho.repository.dumpToFile.systemView";
    public static final String PROP_DUMP_TO_FILE_DOCUMENT_VIEW = "pentaho.repository.dumpToFile.documentView";
    private String fileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startup(IPentahoSession pentahoSession) {
        Mode tmpMode = null;
        if (!StringUtils.hasText((String)this.fileName)) {
            this.fileName = System.getProperty(PROP_DUMP_TO_FILE);
            tmpMode = Mode.CUSTOM;
            if (this.fileName == null) {
                this.fileName = System.getProperty(PROP_DUMP_TO_FILE_SYSTEM_VIEW);
                tmpMode = Mode.SYS;
            }
            if (this.fileName == null) {
                this.fileName = System.getProperty(PROP_DUMP_TO_FILE_DOCUMENT_VIEW);
                tmpMode = Mode.DOC;
            }
        } else {
            tmpMode = Mode.CUSTOM;
        }
        final Mode mode = tmpMode;
        if (this.fileName != null) {
            final JcrTemplate jcrTemplate = (JcrTemplate)PentahoSystem.get(JcrTemplate.class, (String)"jcrTemplate", (IPentahoSession)pentahoSession);
            TransactionTemplate txnTemplate = (TransactionTemplate)PentahoSystem.get(TransactionTemplate.class, (String)"jcrTransactionTemplate", (IPentahoSession)pentahoSession);
            String repositoryAdminUsername = (String)PentahoSystem.get(String.class, (String)"repositoryAdminUsername", (IPentahoSession)pentahoSession);
            String ZIP_EXTENSION = ".zip";
            if (!this.fileName.endsWith(".zip")) {
                this.fileName = this.fileName + ".zip";
            }
            logger.debug((Object)String.format("dumping repository to file \"%s\"", this.fileName));
            ZipOutputStream tmpOut = null;
            try {
                tmpOut = new ZipOutputStream(new BufferedOutputStream(FileUtils.openOutputStream((File)new File(this.fileName))));
            }
            catch (IOException e) {
                IOUtils.closeQuietly(tmpOut);
                throw new RuntimeException(e);
            }
            final ZipOutputStream out = tmpOut;
            IPentahoSession origPentahoSession = PentahoSessionHolder.getSession();
            PentahoSessionHolder.setSession((IPentahoSession)this.createRepositoryAdminPentahoSession(repositoryAdminUsername));
            try {
                txnTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    public void doInTransactionWithoutResult(TransactionStatus status) {
                        jcrTemplate.execute(new JcrCallback(){

                            public Object doInJcr(Session session) throws RepositoryException, IOException {
                                switch (mode) {
                                    case SYS: {
                                        boolean SKIP_BINARY = false;
                                        boolean NO_RECURSE = false;
                                        out.putNextEntry(new ZipEntry("repository.xml"));
                                        session.exportSystemView("/", (OutputStream)out, false, false);
                                        return null;
                                    }
                                    case DOC: {
                                        boolean SKIP_BINARY = false;
                                        boolean NO_RECURSE = false;
                                        out.putNextEntry(new ZipEntry("repository.xml"));
                                        session.exportDocumentView("/", (OutputStream)out, false, false);
                                        return null;
                                    }
                                }
                                out.putNextEntry(new ZipEntry("repository.txt"));
                                session.getRootNode().accept((ItemVisitor)new DumpToFileTraversingItemVisitor(out));
                                return null;
                            }
                        });
                    }
                });
            }
            finally {
                PentahoSessionHolder.setSession((IPentahoSession)origPentahoSession);
                IOUtils.closeQuietly((OutputStream)out);
            }
            logger.debug((Object)String.format("dumped repository to file \"%s\"", this.fileName));
        }
        return true;
    }

    protected IPentahoSession createRepositoryAdminPentahoSession(String repositoryAdminUsername) {
        StandaloneSession pentahoSession = new StandaloneSession(repositoryAdminUsername);
        pentahoSession.setAuthenticated(repositoryAdminUsername);
        return pentahoSession;
    }

    public void shutdown() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static class DumpToFileTraversingItemVisitor
    extends TraversingItemVisitor {
        private OutputStream out;
        private static final String INDENT = "  ";
        private static final String ENCODING = "UTF-8";
        private static final String NL = System.getProperty("line.separator");

        public DumpToFileTraversingItemVisitor(OutputStream out) {
            this.out = out;
        }

        protected void entering(Property property, int level) throws RepositoryException {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                buf.append(INDENT);
            }
            this.propertyToString(property, buf);
            try {
                IOUtils.write((CharSequence)buf, (OutputStream)this.out, (String)ENCODING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void propertyToString(Property property, StringBuilder buf) throws RepositoryException {
            buf.append("@");
            buf.append(property.getName());
            buf.append("=");
            try {
                Value value = property.getValue();
                this.valueToString(value, buf);
            }
            catch (ValueFormatException e) {
                Value[] values = property.getValues();
                buf.append("[");
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    this.valueToString(values[i], buf);
                }
                buf.append("]");
            }
            buf.append(NL);
        }

        protected void valueToString(Value value, StringBuilder buf) throws RepositoryException {
            buf.append(value.getString());
            buf.append(" (");
            buf.append(PropertyType.nameFromValue((int)value.getType()));
            buf.append(")");
        }

        protected void entering(Node node, int level) throws RepositoryException {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                buf.append(INDENT);
            }
            this.nodeToString(node, buf);
            try {
                IOUtils.write((CharSequence)buf, (OutputStream)this.out, (String)ENCODING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void nodeToString(Node node, StringBuilder buf) throws RepositoryException {
            buf.append(node.getName());
            buf.append("/");
            buf.append(NL);
        }

        protected void leaving(Property property, int level) throws RepositoryException {
        }

        protected void leaving(Node node, int level) throws RepositoryException {
        }
    }

    private static enum Mode {
        CUSTOM,
        SYS,
        DOC;

    }
}

