/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.Privilege;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.jcr.IAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.IPentahoInternalPrincipal;

public class JcrAclMetadataStrategy
implements IAclMetadataStrategy {
    private static final Log logger = LogFactory.getLog(JcrAclMetadataStrategy.class);
    private static final String PRIV = "jcr:retentionManagement";

    @Override
    public IAclMetadataStrategy.AclMetadata getAclMetadata(Session session, String path, AccessControlList acList) throws RepositoryException {
        if (session == null || path == null || acList == null) {
            throw new IllegalArgumentException();
        }
        if (session.getRootNode().getPath().equals(path)) {
            return null;
        }
        if (acList.getAccessControlEntries().length == 0) {
            throw new IllegalArgumentException();
        }
        AccessControlEntry firstAce = acList.getAccessControlEntries()[0];
        if (firstAce.getPrincipal() instanceof AclMetadataPrincipal) {
            return ((AclMetadataPrincipal)firstAce.getPrincipal()).getAclMetadata();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setAclMetadata(Session session, String path, AccessControlList acList, IAclMetadataStrategy.AclMetadata aclMetadata) throws RepositoryException {
        if (session == null || path == null || acList == null || aclMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (session.getRootNode().getPath().equals(path)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ignoring setAclMetadata on root node");
            }
            return;
        }
        if (acList.getAccessControlEntries().length != 0) {
            throw new IllegalArgumentException();
        }
        if (!acList.addAccessControlEntry((Principal)new AclMetadataPrincipal(aclMetadata), new Privilege[]{session.getAccessControlManager().privilegeFromName(PRIV)})) {
            throw new RepositoryException();
        }
    }

    @Override
    public List<AccessControlEntry> removeAclMetadata(List<AccessControlEntry> acEntries) throws RepositoryException {
        ArrayList<AccessControlEntry> cleanedAcEntries = new ArrayList<AccessControlEntry>(acEntries.size());
        for (AccessControlEntry acEntry : acEntries) {
            if (acEntry.getPrincipal() instanceof IPentahoInternalPrincipal) continue;
            cleanedAcEntries.add(acEntry);
        }
        return cleanedAcEntries;
    }

    public static class AclMetadataPrincipal
    implements IPentahoInternalPrincipal {
        public static final String PRINCIPAL_PREFIX = "org.pentaho.jcr";
        public static final char SEPARATOR = ':';
        private static final List<Character> RESERVED_CHARS = Arrays.asList(Character.valueOf(':'));
        private final IAclMetadataStrategy.AclMetadata aclMetadata;
        private final String encodedName;

        public AclMetadataPrincipal(IAclMetadataStrategy.AclMetadata aclMetadata) {
            this.aclMetadata = aclMetadata;
            this.encodedName = "org.pentaho.jcr:" + RepositoryFilenameUtils.escape(aclMetadata.getOwner(), RESERVED_CHARS) + ':' + aclMetadata.isEntriesInheriting();
        }

        public AclMetadataPrincipal(String encodedName) {
            this.encodedName = encodedName;
            String[] tokens = encodedName.split("\\:");
            if (tokens.length != 3) {
                throw new IllegalArgumentException();
            }
            if (!tokens[0].equals(PRINCIPAL_PREFIX)) {
                throw new IllegalArgumentException();
            }
            String owner = RepositoryFilenameUtils.unescape(tokens[1]);
            boolean entriesInheriting = Boolean.parseBoolean(tokens[2]);
            this.aclMetadata = new IAclMetadataStrategy.AclMetadata(owner, entriesInheriting);
        }

        @Override
        public String getName() {
            return this.encodedName;
        }

        public IAclMetadataStrategy.AclMetadata getAclMetadata() {
            return this.aclMetadata;
        }

        public static boolean isAclMetadataPrincipal(String name) {
            return name.startsWith("org.pentaho.jcr:");
        }

        @Override
        public String toString() {
            return "AclMetadataPrincipal [aclMetadata=" + this.aclMetadata + ", encodedName=" + this.encodedName + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.encodedName == null ? 0 : this.encodedName.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AclMetadataPrincipal other = (AclMetadataPrincipal)obj;
            return !(this.encodedName == null ? other.encodedName != null : !this.encodedName.equals(other.encodedName));
        }
    }
}

