/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices.jaxws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;
import org.pentaho.platform.repository2.unified.webservices.jaxws.IUnifiedRepositoryJaxwsWebService;
import org.pentaho.platform.repository2.unified.webservices.jaxws.SimpleRepositoryFileDataDto;

@WebService(endpointInterface="org.pentaho.platform.repository2.unified.webservices.jaxws.IUnifiedRepositoryJaxwsWebService", serviceName="unifiedRepository", portName="unifiedRepositoryPort", targetNamespace="http://www.pentaho.org/ws/1.0")
public class DefaultUnifiedRepositoryJaxwsWebService
extends DefaultUnifiedRepositoryWebService
implements IUnifiedRepositoryJaxwsWebService {
    public DefaultUnifiedRepositoryJaxwsWebService() {
    }

    public DefaultUnifiedRepositoryJaxwsWebService(IUnifiedRepository repo) {
        super(repo);
    }

    @Override
    public RepositoryFileDto createBinaryFileWithAcl(String parentFolderId, RepositoryFileDto file, SimpleRepositoryFileDataDto simpleJaxWsData, RepositoryFileAclDto acl, String versionMessage) {
        this.validateEtcWriteAccess(parentFolderId);
        return this.repositoryFileAdapter.marshal(this.repo.createFile((Serializable)((Object)parentFolderId), this.repositoryFileAdapter.unmarshal(file), (IRepositoryFileData)SimpleRepositoryFileDataDto.convert(simpleJaxWsData), this.repositoryFileAclAdapter.unmarshal(acl), versionMessage));
    }

    @Override
    public RepositoryFileDto createBinaryFile(String parentFolderId, RepositoryFileDto file, SimpleRepositoryFileDataDto simpleJaxWsData, String versionMessage) {
        this.validateEtcWriteAccess(parentFolderId);
        return this.repositoryFileAdapter.marshal(this.repo.createFile((Serializable)((Object)parentFolderId), this.repositoryFileAdapter.unmarshal(file), (IRepositoryFileData)SimpleRepositoryFileDataDto.convert(simpleJaxWsData), versionMessage));
    }

    @Override
    public SimpleRepositoryFileDataDto getDataAsBinaryForRead(String fileId) {
        SimpleRepositoryFileData simpleData = (SimpleRepositoryFileData)this.repo.getDataForRead((Serializable)((Object)fileId), SimpleRepositoryFileData.class);
        return SimpleRepositoryFileDataDto.convert(simpleData);
    }

    @Override
    public SimpleRepositoryFileDataDto getDataAsBinaryForReadAtVersion(String fileId, String versionId) {
        SimpleRepositoryFileData simpleData = (SimpleRepositoryFileData)this.repo.getDataAtVersionForRead((Serializable)((Object)fileId), (Serializable)((Object)versionId), SimpleRepositoryFileData.class);
        return SimpleRepositoryFileDataDto.convert(simpleData);
    }

    @Override
    public RepositoryFileDto updateBinaryFile(RepositoryFileDto file, SimpleRepositoryFileDataDto simpleJaxWsData, String versionMessage) {
        return this.repositoryFileAdapter.marshal(this.repo.updateFile(this.repositoryFileAdapter.unmarshal(file), (IRepositoryFileData)SimpleRepositoryFileDataDto.convert(simpleJaxWsData), versionMessage));
    }

    @Override
    public List<SimpleRepositoryFileDataDto> getDataAsBinaryForReadInBatch(List<RepositoryFileDto> files) {
        ArrayList<SimpleRepositoryFileDataDto> data = new ArrayList<SimpleRepositoryFileDataDto>(files.size());
        for (RepositoryFileDto f : files) {
            if (f.getVersionId() == null) {
                data.add(SimpleRepositoryFileDataDto.convert((SimpleRepositoryFileData)this.repo.getDataForRead((Serializable)((Object)f.getId()), SimpleRepositoryFileData.class)));
                continue;
            }
            data.add(SimpleRepositoryFileDataDto.convert((SimpleRepositoryFileData)this.repo.getDataAtVersionForExecute((Serializable)((Object)f.getId()), (Serializable)((Object)f.getVersionId()), SimpleRepositoryFileData.class)));
        }
        return data;
    }
}

