/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.SimpleCopyListing;

public class GlobbedCopyListing
extends CopyListing {
    private static final Log LOG = LogFactory.getLog(GlobbedCopyListing.class);
    private final CopyListing simpleListing;

    public GlobbedCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
        this.simpleListing = new SimpleCopyListing(this.getConf(), credentials);
    }

    @Override
    protected void validatePaths(DistCpContext context) throws IOException, CopyListing.InvalidInputException {
    }

    @Override
    public void doBuildListing(Path pathToListingFile, DistCpContext context) throws IOException {
        ArrayList<Path> globbedPaths = new ArrayList<Path>();
        if (context.getSourcePaths().isEmpty()) {
            throw new CopyListing.InvalidInputException("Nothing to process. Source paths::EMPTY");
        }
        for (Path p : context.getSourcePaths()) {
            FileSystem fs = p.getFileSystem(this.getConf());
            FileStatus[] inputs = fs.globStatus(p);
            if (inputs != null && inputs.length > 0) {
                for (FileStatus onePath : inputs) {
                    globbedPaths.add(onePath.getPath());
                }
                continue;
            }
            throw new CopyListing.InvalidInputException(p + " doesn't exist");
        }
        context.setSourcePaths(globbedPaths);
        this.simpleListing.buildListing(pathToListingFile, context);
    }

    @Override
    protected long getBytesToCopy() {
        return this.simpleListing.getBytesToCopy();
    }

    @Override
    protected long getNumberOfPaths() {
        return this.simpleListing.getNumberOfPaths();
    }
}

