/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class AS400XChgRandSeedReplyDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";

    AS400XChgRandSeedReplyDS() {
    }

    int getRC() {
        return this.get32bit(20);
    }

    byte[] getServerSeed() {
        byte[] byArray = new byte[8];
        System.arraycopy(this.data_, 24, byArray, 0, 8);
        return byArray;
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving exchange random seeds reply...");
        }
        if (DataStream.readFromStream(inputStream, byArray = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the exchange random seeds reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 20);
        this.readAfterHeader(inputStream);
    }
}

