/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStreamImpl;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;

public class IFSFileOutputStream
extends OutputStream
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    protected transient PropertyChangeSupport changes_;
    protected transient VetoableChangeSupport vetos_;
    protected IFSFileDescriptor fd_;
    transient Vector fileListeners_;
    transient IFSFileOutputStreamImpl impl_;
    private boolean append_ = false;
    private int ccsid_ = -1;

    public IFSFileOutputStream() {
        this.fd_ = new IFSFileDescriptor(-1, this);
        this.initializeTransient();
    }

    public IFSFileOutputStream(AS400 aS400, String string) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.myConstructor(aS400, string, -1, false, -1);
    }

    public IFSFileOutputStream(AS400 aS400, String string, int n) throws AS400SecurityException, IOException {
        this(aS400, string, -1, false, n);
    }

    public IFSFileOutputStream(AS400 aS400, String string, int n, boolean bl) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        IFSFileInputStream.validateShareOption(n);
        this.myConstructor(aS400, string, n, bl, -1);
    }

    public IFSFileOutputStream(AS400 aS400, String string, int n, boolean bl, int n2) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        IFSFileInputStream.validateShareOption(n);
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(aS400, string, n, bl, n2);
    }

    public IFSFileOutputStream(IFSFile iFSFile) throws AS400SecurityException, IOException {
        this(iFSFile == null ? null : iFSFile.getSystem(), iFSFile, -1, false);
    }

    public IFSFileOutputStream(AS400 aS400, IFSFile iFSFile, int n, boolean bl) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        IFSFileInputStream.validateShareOption(n);
        this.myConstructor(aS400, iFSFile.getAbsolutePath(), n, bl, -1);
    }

    public IFSFileOutputStream(IFSFile iFSFile, int n, boolean bl) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        IFSFileInputStream.validateShareOption(n);
        this.myConstructor(iFSFile.getSystem(), iFSFile.getAbsolutePath(), n, bl, -1);
    }

    public IFSFileOutputStream(AS400 aS400, IFSFile iFSFile, int n, boolean bl, int n2) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        IFSFileInputStream.validateShareOption(n);
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(aS400, iFSFile.getAbsolutePath(), n, bl, n2);
    }

    public IFSFileOutputStream(IFSFile iFSFile, int n, boolean bl, int n2) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        IFSFileInputStream.validateShareOption(n);
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(iFSFile.getSystem(), iFSFile.getAbsolutePath(), n, bl, n2);
    }

    void myConstructor(AS400 aS400, String string, int n, boolean bl, int n2) throws AS400SecurityException, IOException {
        this.append_ = bl;
        this.ccsid_ = n2;
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(aS400, string, n, this);
        this.connectAndOpen();
    }

    public IFSFileOutputStream(IFSFileDescriptor iFSFileDescriptor) {
        if (iFSFileDescriptor == null) {
            throw new NullPointerException("fd");
        }
        IFSFileInputStream.validateShareOption(iFSFileDescriptor.getShareOption());
        this.initializeTransient();
        this.fd_ = iFSFileDescriptor;
    }

    public IFSFileOutputStream(IFSJavaFile iFSJavaFile) throws AS400SecurityException, IOException {
        this(iFSJavaFile == null ? null : iFSJavaFile.getSystem(), iFSJavaFile, -1, false);
    }

    public IFSFileOutputStream(AS400 aS400, IFSJavaFile iFSJavaFile, int n, boolean bl) throws AS400SecurityException, IOException {
        if (iFSJavaFile == null) {
            throw new NullPointerException("file");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        IFSFileInputStream.validateShareOption(n);
        this.myConstructor(aS400, iFSJavaFile.getAbsolutePath().replace(File.separatorChar, '/'), n, bl, -1);
    }

    public IFSFileOutputStream(AS400 aS400, IFSJavaFile iFSJavaFile, int n, boolean bl, int n2) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (iFSJavaFile == null) {
            throw new NullPointerException("file");
        }
        IFSFileInputStream.validateShareOption(n);
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(aS400, iFSJavaFile.getAbsolutePath().replace(File.separatorChar, '/'), n, bl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.addElement(fileListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void chooseImpl() {
        if (this.impl_ == null) {
            AS400 aS400 = this.fd_.getSystem();
            if (aS400 == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (IFSFileOutputStreamImpl)aS400.loadImpl2("com.ibm.as400.access.IFSFileOutputStreamImplRemote", "com.ibm.as400.access.IFSFileOutputStreamImplProxy");
            this.impl_.setFD(this.fd_.getImpl());
            this.impl_.setAppend(this.append_);
        }
    }

    public void close() throws IOException {
        if (!this.fd_.isClosed() && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireClosedEvents(this, this.fileListeners_);
            }
        }
    }

    private void connectAndOpen() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            this.fd_.getSystem().connectService(0);
        }
        this.impl_.connectAndOpen(this.ccsid_);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    protected void finalize() throws IOException {
        if (this.fd_ != null && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
    }

    public void flush() throws IOException {
        if (this.fd_.isClosed()) {
            Trace.log(2, "The stream has been closed.");
            throw new IOException();
        }
        this.open(this.ccsid_);
        this.impl_.flush();
    }

    int getCCSID() {
        return this.ccsid_;
    }

    public final IFSFileDescriptor getFD() throws IOException {
        return this.fd_;
    }

    IFSFileOutputStreamImpl getImpl() {
        return this.impl_;
    }

    public String getPath() {
        return this.fd_.getPath();
    }

    public int getShareOption() {
        return this.fd_.getShareOption();
    }

    public AS400 getSystem() {
        return this.fd_.getSystem();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.impl_ = null;
    }

    public IFSKey lock(int n) throws IOException {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("length (" + Integer.toString(n) + ")", 2);
        }
        this.open(this.ccsid_);
        return this.impl_.lock(n);
    }

    protected void open(int n) throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            try {
                this.fd_.getSystem().connectService(0);
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)aS400SecurityException);
                throw new ExtendedIOException(5);
            }
        }
        if (this.fd_.isOpen()) {
            return;
        }
        this.impl_.open(n);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.removeElement(fileListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setAppend(boolean bl) throws PropertyVetoException {
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("append", 5);
        }
        Boolean bl2 = new Boolean(this.append_);
        Boolean bl3 = new Boolean(bl);
        this.vetos_.fireVetoableChange("append", bl2, bl3);
        this.append_ = bl;
        this.changes_.firePropertyChange("append", bl2, bl3);
    }

    void setCCSID(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        if (this.fd_.isOpen()) {
            throw new ExtendedIllegalStateException("CCSID", 5);
        }
        Integer n2 = new Integer(this.ccsid_);
        Integer n3 = new Integer(n);
        this.vetos_.fireVetoableChange("CCSID", n2, n3);
        this.ccsid_ = n;
        this.changes_.firePropertyChange("CCSID", n2, n3);
    }

    public void setFD(IFSFileDescriptor iFSFileDescriptor) throws PropertyVetoException {
        if (iFSFileDescriptor == null) {
            throw new NullPointerException("fd");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("FD", 5);
        }
        this.vetos_.fireVetoableChange("FD", this.fd_, iFSFileDescriptor);
        IFSFileDescriptor iFSFileDescriptor2 = this.fd_;
        this.fd_ = iFSFileDescriptor;
        this.changes_.firePropertyChange("FD", iFSFileDescriptor2, this.fd_);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = this.fd_.getPath();
        String string3 = string.length() == 0 || string.charAt(0) != '/' ? "/" + string : string;
        this.vetos_.fireVetoableChange("path", string2, string3);
        this.fd_.setPath(string3);
        this.changes_.firePropertyChange("path", string2, string3);
    }

    public void setShareOption(int n) throws PropertyVetoException {
        IFSFileInputStream.validateShareOption(n);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        Integer n2 = new Integer(this.fd_.getShareOption());
        Integer n3 = new Integer(n);
        this.vetos_.fireVetoableChange("shareOption", n2, n3);
        this.fd_.setShareOption(n);
        this.changes_.firePropertyChange("shareOption", n2, n3);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.fd_.valid()) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.fd_.getSystem();
        this.vetos_.fireVetoableChange("system", aS4002, aS400);
        this.fd_.setSystem(aS400);
        this.changes_.firePropertyChange("system", aS4002, aS400);
    }

    public void unlock(IFSKey iFSKey) throws IOException {
        if (iFSKey == null) {
            throw new NullPointerException("key");
        }
        this.open(this.ccsid_);
        this.impl_.unlock(iFSKey);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.open(this.ccsid_);
        this.impl_.write(byArray, n, n2);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }
}

