/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectTransformedInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.SpooledFileImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class PrintObjectTransformedInputStreamImplRemote
implements PrintObjectTransformedInputStreamImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private NPConversation conversation_;
    private NPCPAttribute cpCPFMsg_;
    private NPCodePoint cpObjHndl_;
    private NPCPID cpObjID_;
    private NPSystem npSystem_;
    private int numBytes_ = 0;
    private int objectType_;
    private int offset_ = 0;
    private boolean cidConv = false;
    private String convSource = null;
    private String convTarget = null;

    PrintObjectTransformedInputStreamImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPrintObjectTransformedInputStream(SpooledFileImpl spooledFileImpl, PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Object object;
        AS400ImplRemote aS400ImplRemote = ((SpooledFileImplRemote)spooledFileImpl).getSystem();
        int n = aS400ImplRemote.getCcsid();
        this.objectType_ = 1;
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)spooledFileImpl).getSystem());
        this.cpObjID_ = ((SpooledFileImplRemote)spooledFileImpl).getIDCodePoint();
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjHndl_ = new NPCPSplFHandle();
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(26);
        nPDataStream.addCodePoint(this.cpObjID_);
        NPCPSelection nPCPSelection = new NPCPSelection();
        if (printParameterList != null) {
            nPCPSelection.addUpdateAttributes(printParameterList.getAttrCodePoint());
            object = printParameterList.getStringParameter(264);
            if (object != null) {
                this.cidConv = true;
                this.convTarget = ((String)object).replace('P', 'p');
                switch (n) {
                    case 37: 
                    case 836: {
                        this.convSource = "Cp437";
                        break;
                    }
                    case 420: {
                        this.convSource = "Cp864";
                        break;
                    }
                    case 423: {
                        this.convSource = "Cp1253";
                        break;
                    }
                    case 424: {
                        this.convSource = "Cp856";
                        break;
                    }
                    case 838: 
                    case 1130: 
                    case 1132: 
                    case 1164: {
                        this.convSource = "Cp874";
                        break;
                    }
                    case 870: {
                        this.convSource = "Cp852";
                        break;
                    }
                    case 875: {
                        this.convSource = "Cp869";
                        break;
                    }
                    case 905: 
                    case 1026: {
                        this.convSource = "Cp857";
                        break;
                    }
                    case 1097: {
                        this.convSource = "Cp1097";
                        break;
                    }
                    case 1112: {
                        this.convSource = "Cp921";
                        break;
                    }
                    case 1122: {
                        this.convSource = "Cp922";
                        break;
                    }
                    case 1153: {
                        this.convSource = "Cp1250";
                        break;
                    }
                    case 1154: 
                    case 1158: {
                        this.convSource = "Cp1251";
                        break;
                    }
                    case 1155: {
                        this.convSource = "Cp1254";
                        break;
                    }
                    case 1156: 
                    case 1157: {
                        this.convSource = "Cp1257";
                        break;
                    }
                    case 1160: {
                        this.convSource = "Cp874";
                        break;
                    }
                    case 1390: 
                    case 1399: 
                    case 5026: 
                    case 5035: {
                        this.convSource = "Cp942";
                        break;
                    }
                    case 933: 
                    case 1364: {
                        this.convSource = "Cp949";
                        break;
                    }
                    case 937: 
                    case 1371: 
                    case 1388: {
                        this.convSource = "Cp950";
                        break;
                    }
                    case 935: {
                        this.convSource = "Cp1381";
                        break;
                    }
                    default: {
                        this.convSource = "Cp850";
                    }
                }
                printParameterList.setParameter(263, this.convSource);
            }
        }
        nPDataStream.addCodePoint(nPCPSelection);
        object = new NPDataStream(this.objectType_);
        ((NPDataStream)object).addCodePoint(this.cpObjHndl_);
        ((NPDataStream)object).addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean bl = false;
        try {
            int n2 = this.conversation_.makeRequest(nPDataStream, (NPDataStream)object);
            if (n2 != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + n2);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrieveNumberOfBytes();
            bl = true;
            Object var11_10 = null;
            if (!bl) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (!bl) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
            throw throwable;
        }
    }

    public int available() throws IOException {
        return this.numBytes_ - this.offset_;
    }

    public void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(5);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            block7: {
                try {
                    int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
                    if (n == 0) break block7;
                    Trace.log(2, "Error closing SpooledFile; rc = " + n);
                    this.npSystem_.returnConversation(this.conversation_);
                }
                catch (Exception exception) {
                    Trace.log(2, "Caught an Exception." + exception.toString());
                    throw new IOException(exception.toString());
                }
            }
            Object var5_5 = null;
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            NPDataStream nPDataStream = new NPDataStream(this.objectType_);
            nPDataStream.setAction(5);
            nPDataStream.addCodePoint(this.cpObjHndl_);
            AS400Server aS400Server = this.conversation_.getServer();
            if (aS400Server != null) {
                nPDataStream.setConverter(this.conversation_.getConverter());
                aS400Server.sendAndDiscardReply(nPDataStream);
            }
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        super.finalize();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        Integer n5 = new Integer(byArray.length);
        byte[] byArray2 = new byte[n2];
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPCPAttribute.setAttrValue(125, n2);
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(3);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttribute);
        NPCPData nPCPData = new NPCPData();
        nPCPData.setDataBuffer(byArray, 0, n);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(nPCPData);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n6 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (this.cidConv) {
                String string = new String(byArray, n, n2, this.convSource);
                byArray2 = string.getBytes(this.convTarget);
                Integer n7 = new Integer(byArray2.length);
                n4 = n7.compareTo(n5) >= 0 ? n5.intValue() : n7.intValue();
                System.arraycopy(byArray2, 0, byArray, 0, n4);
            }
            switch (n6) {
                case 0: 
                case 18: {
                    n3 = nPCPData.getDataLength();
                    this.offset_ += n3;
                    if (nPDataStream2.get32bit(22) == 0x20000000) {
                        this.retrieveNumberOfBytes();
                        this.offset_ = 0;
                    }
                    break;
                }
                case 19: {
                    n3 = -1;
                    break;
                }
                default: {
                    Trace.log(2, "Error received on read : " + Integer.toString(n6));
                    throw new IOException(Integer.toString(n6));
                }
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
        return n3;
    }

    private void retrieveNumberOfBytes() throws IOException, RequestNotSupportedException {
        NPCPAttributeIDList nPCPAttributeIDList = new NPCPAttributeIDList();
        nPCPAttributeIDList.addAttrID(125);
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttributeIDList);
        nPDataStream.setAction(24);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPDataStream2.addCodePoint(nPCPAttribute);
        try {
            Integer n;
            int n2 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (n2 == 0) {
                n = nPCPAttribute.getIntValue(125);
                if (n == null) {
                    Trace.log(2, "Network Print Server does not support retrieving data block length.");
                    throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
                }
            } else {
                Trace.log(2, "Network Print Server error retrieving data block length. RC =" + n2);
                throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
            }
            this.numBytes_ = n;
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }

    private void seekFromCur(int n) throws IOException {
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPCPAttribute.setAttrValue(127, 2);
        nPCPAttribute.setAttrValue(126, n);
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(23);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttribute);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n2 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            switch (n2) {
                case 0: {
                    this.offset_ += n;
                    break;
                }
                default: {
                    Trace.log(2, "Seek from cur error " + Integer.toString(n2));
                    throw new IOException(Integer.toString(n2));
                }
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }

    public long skip(long l) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        int n = this.numBytes_ - this.offset_;
        if (l > (long)n) {
            l = n;
        }
        this.seekFromCur((int)l);
        return l;
    }
}

