/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400FileRecordDescription;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.FloatFieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.KeyedFile;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import com.ibm.as400.access.TimeFieldDescription;
import com.ibm.as400.access.TimestampFieldDescription;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import com.ibm.as400.vaccess.DBDateCellRenderer;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

class RecordListData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final int KEY_EQ = 0;
    static final int KEY_GT = 1;
    static final int KEY_GE = 2;
    static final int KEY_LT = 3;
    static final int KEY_LE = 4;
    private AS400 system_ = null;
    private String fileName_ = null;
    private boolean newKeyed_ = false;
    private boolean keyed_ = false;
    private int searchType_ = 0;
    private int newSearchType_ = 0;
    private Object[] key_ = null;
    private Object[] newKey_ = null;
    private transient SequentialFile sequentialFile_ = null;
    private transient KeyedFile keyedFile_ = null;
    private transient boolean loadDone_ = false;
    private transient boolean resourceOpen_ = false;
    private transient Object[][] data_ = null;
    transient Record record_;
    private transient int numColumns_ = 0;
    transient FieldDescription[] fields_ = null;
    private static int ROW_INCREMENT_ = 100;
    private transient int numRows_ = 0;
    private transient int lastRecordRead_ = -1;
    private transient int lastLESSRecordNumber_;
    private transient boolean allRecordsRead_ = true;
    private transient boolean error_;
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    private boolean fireWorkingEvents_ = true;

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.addWorkingListener(workingListener);
    }

    public synchronized void close() {
        if (this.resourceOpen_) {
            try {
                if (this.keyed_) {
                    this.keyedFile_.close();
                } else {
                    this.sequentialFile_.close();
                }
            }
            catch (Exception exception) {
                this.errorListeners_.fireError(exception);
            }
            this.resourceOpen_ = false;
        }
    }

    public synchronized boolean getAllRecordsProcessed() {
        return this.allRecordsRead_;
    }

    public synchronized int getColumnDisplaySize(int n) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("index");
        }
        FieldDescription fieldDescription = this.fields_[n];
        if (fieldDescription instanceof FloatFieldDescription || fieldDescription instanceof PackedDecimalFieldDescription || fieldDescription instanceof ZonedDecimalFieldDescription) {
            return fieldDescription.getLength() + 2;
        }
        if (fieldDescription instanceof TimeFieldDescription) {
            return DBDateCellRenderer.getDisplaySize(1);
        }
        if (fieldDescription instanceof DateFieldDescription) {
            return DBDateCellRenderer.getDisplaySize(3);
        }
        if (fieldDescription instanceof TimestampFieldDescription) {
            return DBDateCellRenderer.getDisplaySize(2);
        }
        if (fieldDescription instanceof HexFieldDescription) {
            return fieldDescription.getLength() * 2;
        }
        return fieldDescription.getLength();
    }

    public synchronized String getColumnLabel(int n) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("index");
        }
        return this.fields_[n].getFieldName();
    }

    public synchronized String getColumnName(int n) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("index");
        }
        return this.fields_[n].getFieldName();
    }

    public String getFileName() {
        return this.fileName_;
    }

    public Object[] getKey() {
        return this.newKey_;
    }

    public boolean getKeyed() {
        return this.newKeyed_;
    }

    public synchronized int getLastRecordProcessed() {
        return this.lastRecordRead_;
    }

    public synchronized int getNumberOfColumns() {
        return this.numColumns_;
    }

    public synchronized int getNumberOfRows() {
        if (!this.allRecordsRead_) {
            this.readAllRecords();
        }
        return this.numRows_;
    }

    public int getSearchType() {
        return this.newSearchType_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public synchronized Object getValueAt(int n, int n2) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        if (this.lastRecordRead_ < n) {
            this.readMoreRecords(n - this.lastRecordRead_);
        }
        if (this.lastRecordRead_ < n) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        return this.data_[n][n2];
    }

    public synchronized void load() {
        RecordFormat[] recordFormatArray;
        Trace.log(1, "Doing data load.");
        if (this.system_ == null || this.fileName_ == null) {
            Trace.log(1, "Data not set for load, exiting.");
            return;
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStartWorking();
        }
        if (this.resourceOpen_) {
            this.resourceOpen_ = false;
            this.close();
        }
        this.fields_ = null;
        this.numColumns_ = 0;
        this.lastRecordRead_ = -1;
        this.allRecordsRead_ = true;
        this.loadDone_ = false;
        this.data_ = null;
        this.numRows_ = 0;
        this.key_ = this.newKey_;
        this.searchType_ = this.newSearchType_;
        this.keyed_ = this.newKeyed_;
        try {
            AS400FileRecordDescription aS400FileRecordDescription = new AS400FileRecordDescription(this.system_, this.fileName_);
            recordFormatArray = aS400FileRecordDescription.retrieveRecordFormat();
        }
        catch (Exception exception) {
            this.errorListeners_.fireError(exception);
            return;
        }
        this.fields_ = recordFormatArray[0].getFieldDescriptions();
        this.numColumns_ = this.fields_.length;
        if (!this.keyed_) {
            this.keyedFile_ = null;
            try {
                this.sequentialFile_ = new SequentialFile(this.system_, this.fileName_);
            }
            catch (Exception exception) {
                this.fields_ = null;
                this.numColumns_ = 0;
                this.errorListeners_.fireError(exception);
                return;
            }
            try {
                this.sequentialFile_.setRecordFormat(recordFormatArray[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            try {
                this.sequentialFile_.open(0, ROW_INCREMENT_, 3);
                this.record_ = this.sequentialFile_.readNext();
                this.resourceOpen_ = true;
            }
            catch (Exception exception) {
                try {
                    this.sequentialFile_.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.fields_ = null;
                this.numColumns_ = 0;
                this.errorListeners_.fireError(exception);
                return;
            }
        }
        this.sequentialFile_ = null;
        try {
            this.keyedFile_ = new KeyedFile(this.system_, this.fileName_);
        }
        catch (Exception exception) {
            this.fields_ = null;
            this.numColumns_ = 0;
            this.errorListeners_.fireError(exception);
            return;
        }
        try {
            this.keyedFile_.setRecordFormat(recordFormatArray[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.keyedFile_.open(0, ROW_INCREMENT_, 3);
            if (this.key_ != null) {
                this.record_ = this.keyedFile_.read(this.key_, this.searchType_);
                if (this.searchType_ == 4) {
                    try {
                        Record record = this.keyedFile_.readNextEqual(this.key_);
                        while (record != null) {
                            this.record_ = record;
                            record = this.keyedFile_.readNextEqual(this.key_);
                        }
                    }
                    catch (Exception exception) {
                        this.errorListeners_.fireError(exception);
                    }
                }
                if (this.searchType_ == 4 || this.searchType_ == 3) {
                    this.lastLESSRecordNumber_ = this.record_.getRecordNumber();
                    this.record_ = this.keyedFile_.readFirst();
                }
            } else {
                this.record_ = this.keyedFile_.readNext();
            }
            this.resourceOpen_ = true;
        }
        catch (Exception exception) {
            try {
                this.keyedFile_.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            this.fields_ = null;
            this.numColumns_ = 0;
            this.errorListeners_.fireError(exception);
            return;
        }
        if (this.record_ != null) {
            this.data_ = new Object[ROW_INCREMENT_][this.numColumns_];
            this.allRecordsRead_ = false;
        }
        this.loadDone_ = true;
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    public synchronized void readAllRecords() {
        Trace.log(1, "Reading all rows.");
        this.workingListeners_.fireStartWorking();
        this.error_ = false;
        while (!this.allRecordsRead_ && !this.error_) {
            this.fireWorkingEvents_ = false;
            this.readMoreRecords(ROW_INCREMENT_);
            this.fireWorkingEvents_ = true;
        }
        this.workingListeners_.fireStopWorking();
    }

    public synchronized void readMoreRecords(int n) {
        Trace.log(1, "Reading more rows:", n);
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStartWorking();
        }
        this.error_ = false;
        if (!this.allRecordsRead_) {
            int n2;
            int n3;
            if (this.lastRecordRead_ + n >= this.data_.length) {
                n3 = this.lastRecordRead_ + n + 1;
                n2 = ROW_INCREMENT_ > n3 ? ROW_INCREMENT_ : n3;
                Object[][] objectArray = new Object[this.data_.length + n2][this.numColumns_];
                System.arraycopy(this.data_, 0, objectArray, 0, this.data_.length);
                this.data_ = objectArray;
            }
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < this.numColumns_; ++n2) {
                    try {
                        this.data_[this.lastRecordRead_ + 1][n2] = this.record_.getField(n2);
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.data_[this.lastRecordRead_ + 1][n2] = null;
                        this.errorListeners_.fireError(unsupportedEncodingException);
                    }
                }
                ++this.lastRecordRead_;
                if (!this.keyed_) {
                    try {
                        this.record_ = this.sequentialFile_.readNext();
                    }
                    catch (Exception exception) {
                        this.errorListeners_.fireError(exception);
                        this.error_ = true;
                        this.record_ = null;
                    }
                } else {
                    try {
                        this.record_ = this.key_ != null ? (this.searchType_ == 0 ? this.keyedFile_.readNextEqual(this.key_) : ((this.searchType_ == 3 || this.searchType_ == 4) && this.lastLESSRecordNumber_ == this.record_.getRecordNumber() ? null : this.keyedFile_.readNext())) : this.keyedFile_.readNext();
                    }
                    catch (Exception exception) {
                        this.errorListeners_.fireError(exception);
                        this.error_ = true;
                        this.record_ = null;
                    }
                }
                if (this.record_ != null) continue;
                this.allRecordsRead_ = true;
                this.close();
                this.numRows_ = this.lastRecordRead_ + 1;
                break;
            }
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data_ = null;
        this.sequentialFile_ = null;
        this.keyedFile_ = null;
        this.loadDone_ = false;
        this.resourceOpen_ = false;
        this.numColumns_ = 0;
        this.fields_ = null;
        this.numRows_ = 0;
        this.lastRecordRead_ = -1;
        this.allRecordsRead_ = true;
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.removeWorkingListener(workingListener);
    }

    public void setFileName(String string) {
        this.fileName_ = string;
    }

    public void setKey(Object[] objectArray) {
        this.newKey_ = objectArray;
    }

    public void setKeyed(boolean bl) {
        this.newKeyed_ = bl;
    }

    public void setSearchType(int n) {
        this.newSearchType_ = n;
    }

    public void setSystem(AS400 aS400) {
        this.system_ = aS400;
    }
}

