/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VSystemValue;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class VSysvalDatePane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private DateFormat formatter_;
    private JTextField jTextField_;
    private VSystemValue systemValue_;
    private static final String modifyActionTab_;
    private static final String valueName_;
    private static final String valueDescription_;
    private static final String valueInformation_;
    private static DateFormat dateFormat_;
    private static DateFormat timeFormat_;

    VSysvalDatePane(VSystemValue vSystemValue) {
        this.systemValue_ = vSystemValue;
        if (vSystemValue.getName().equals("QDATE")) {
            this.formatter_ = dateFormat_;
        } else if (vSystemValue.getName().equals("QTIME")) {
            this.formatter_ = timeFormat_;
        }
        this.formatter_.setLenient(false);
    }

    protected void addKeyPressedNotification(KeyListener keyListener) {
        this.jTextField_.addKeyListener(keyListener);
    }

    protected Component getComponent() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(modifyActionTab_, null, this.getModifyTab());
        return jTabbedPane;
    }

    protected Date getDate() {
        Date date = null;
        try {
            String string = this.jTextField_.getText();
            if (this.systemValue_.getName().equals("QDATE")) {
                date = new java.sql.Date(this.formatter_.parse(string).getTime());
            } else if (this.systemValue_.getName().equals("QTIME")) {
                date = new Time(this.formatter_.parse(string).getTime());
            }
        }
        catch (Exception exception) {
            this.systemValue_.errorEventSupport_.fireError(exception);
        }
        return date;
    }

    private Component getModifyTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        int n2 = ++n;
        ++n;
        VUtilities.constrain(valueName_ + ": ", this.systemValue_.getName(), jPanel, gridBagLayout, n2);
        VUtilities.constrain(new JLabel(valueInformation_ + ": "), jPanel, gridBagLayout, 0, ++n, 1, 1);
        String string = null;
        string = this.formatter_.format((Date)this.systemValue_.getValue());
        this.jTextField_ = new JTextField(string.toString());
        VUtilities.constrain(this.jTextField_, jPanel, gridBagLayout, 1, n, 1, 1);
        int n3 = ++n;
        ++n;
        VUtilities.constrain(valueDescription_ + ": ", this.systemValue_.getDescription(), jPanel, gridBagLayout, n3);
        return jPanel;
    }

    static {
        dateFormat_ = DateFormat.getDateInstance();
        timeFormat_ = DateFormat.getTimeInstance();
        modifyActionTab_ = ResourceLoader.getText("ACTION_MODIFY");
        valueName_ = ResourceLoader.getText("COLUMN_NAME");
        valueDescription_ = ResourceLoader.getText("COLUMN_DESCRIPTION");
        valueInformation_ = ResourceLoader.getText("COLUMN_VALUE");
        dateFormat_.setTimeZone(TimeZone.getDefault());
        timeFormat_.setTimeZone(TimeZone.getDefault());
    }
}

