/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.bytecode;

import javax.jws.WebParam;
import org.codehaus.enunciate.bytecode.InstrumentationInfo;
import org.codehaus.enunciate.bytecode.MethodKey;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class WebParamAnnotationInstrumentation
extends ClassAdapter {
    private static final String WEB_PARAM_DESCRIPTOR = Type.getDescriptor(WebParam.class);
    private static final ThreadLocal<String> CURRENT_CLASS_DESCRIPTOR = new ThreadLocal();
    private final InstrumentationInfo instrumentation;

    public WebParamAnnotationInstrumentation(ClassVisitor cv, InstrumentationInfo instrumentation) {
        super(cv);
        this.instrumentation = instrumentation;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        CURRENT_CLASS_DESCRIPTOR.set(name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        CURRENT_CLASS_DESCRIPTOR.remove();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodKey mk = new MethodKey(CURRENT_CLASS_DESCRIPTOR.get(), name, desc);
        Object mv = super.visitMethod(access, name, desc, signature, exceptions);
        String[] parameterNames = this.instrumentation.getParameterNames().get(mk);
        if (parameterNames != null) {
            mv = new WebParamAnnotationMethodVisitor((MethodVisitor)mv, parameterNames);
        }
        return mv;
    }

    private static class WebParamAnnotationVisitor
    implements AnnotationVisitor {
        private final String parameterName;
        private final AnnotationVisitor delegate;
        private boolean nameVisited = false;

        public WebParamAnnotationVisitor(AnnotationVisitor delegate, String parameterName) {
            this.parameterName = parameterName;
            this.delegate = delegate;
        }

        public void visit(String name, Object value) {
            if ("name".equals(name) && "".equals(value)) {
                this.delegate.visit(name, (Object)this.parameterName);
            } else {
                this.delegate.visit(name, value);
            }
            this.nameVisited = true;
        }

        public void visitEnum(String name, String desc, String value) {
            this.delegate.visitEnum(name, desc, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this.delegate.visitAnnotation(name, desc);
        }

        public AnnotationVisitor visitArray(String name) {
            return this.delegate.visitArray(name);
        }

        public void visitEnd() {
            if (!this.nameVisited) {
                this.delegate.visit("name", (Object)this.parameterName);
            }
            this.delegate.visitEnd();
        }
    }

    private static class WebParamAnnotationMethodVisitor
    extends MethodAdapter {
        private int currentParameter = 0;
        private final String[] parameterNames;

        public WebParamAnnotationMethodVisitor(MethodVisitor mv, String[] parameterNames) {
            super(mv);
            this.parameterNames = parameterNames;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            while (this.currentParameter < parameter) {
                AnnotationVisitor paramVisitor = super.visitParameterAnnotation(this.currentParameter, WEB_PARAM_DESCRIPTOR, true);
                paramVisitor.visit("name", (Object)this.parameterNames[this.currentParameter]);
                paramVisitor.visitEnd();
                ++this.currentParameter;
            }
            AnnotationVisitor av = super.visitParameterAnnotation(parameter, desc, visible);
            if (visible && WEB_PARAM_DESCRIPTOR.equals(desc)) {
                av = new WebParamAnnotationVisitor(av, this.parameterNames[parameter]);
            }
            ++this.currentParameter;
            return av;
        }

        public void visitCode() {
            while (this.currentParameter < this.parameterNames.length) {
                AnnotationVisitor paramVisitor = super.visitParameterAnnotation(this.currentParameter, WEB_PARAM_DESCRIPTOR, true);
                paramVisitor.visit("name", (Object)this.parameterNames[this.currentParameter]);
                paramVisitor.visitEnd();
                ++this.currentParameter;
            }
            super.visitCode();
        }

        public void visitEnd() {
            while (this.currentParameter < this.parameterNames.length) {
                AnnotationVisitor paramVisitor = super.visitParameterAnnotation(this.currentParameter, WEB_PARAM_DESCRIPTOR, true);
                paramVisitor.visit("name", (Object)this.parameterNames[this.currentParameter]);
                paramVisitor.visitEnd();
                ++this.currentParameter;
            }
            super.visitEnd();
        }
    }
}

