/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.ICdeEnvironment;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class CdeEngine {
    protected static CdeEngine instance;
    protected static Log logger;
    protected ICdeEnvironment cdeEnv;

    protected CdeEngine() {
        logger.debug((Object)"Starting ElementEngine");
    }

    protected CdeEngine(ICdeEnvironment environment) {
        this();
        this.cdeEnv = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CdeEngine getInstance() {
        if (instance != null) return instance;
        Class<CdeEngine> clazz = CdeEngine.class;
        synchronized (CdeEngine.class) {
            if (instance != null) return instance;
            instance = new CdeEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ICdeEnvironment getEnvironment() {
        return this.cdeEnv;
    }

    public void setEnvironment(ICdeEnvironment environment) {
        this.cdeEnv = environment;
    }

    public void ensureBasicDirs() {
        IRWAccess repoBase = this.getEnvironment().getContentAccessFactory().getPluginRepositoryWriter(null);
        if (!this.ensureDirExists(repoBase, ".", true)) {
            logger.error((Object)"Couldn't find or create CDE base dir.");
        }
        if (!this.ensureDirExists(repoBase, "components", false)) {
            logger.error((Object)"Couldn't find or create CDE components dir.");
        }
        if (!this.ensureDirExists(repoBase, "styles", false)) {
            logger.error((Object)"Couldn't find or create CDE styles dir.");
        }
        if (!this.ensureDirExists(repoBase, "templates", false)) {
            logger.error((Object)"Couldn't find or create CDE templates dir.");
        } else {
            if (!this.ensureDirExists(repoBase, "templates/blueprint", false)) {
                logger.error((Object)"Couldn't find or create CDE templates/blueprint dir.");
            }
            if (!this.ensureDirExists(repoBase, "templates/bootstrap", false)) {
                logger.error((Object)"Couldn't find or create CDE templates/bootstrap dir.");
            }
        }
        if (!repoBase.fileExists("widgets")) {
            if (!this.ensureDirExists(repoBase, "widgets", false)) {
                logger.error((Object)"Couldn't find or create CDE widgets dir.");
            } else {
                IReadAccess sysPluginSamples = this.getEnvironment().getContentAccessFactory().getPluginSystemReader("resources/samples/");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.cdfde"}), sysPluginSamples, "widget.cdfde");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.wcdf"}), sysPluginSamples, "widget.wcdf");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.cda"}), sysPluginSamples, "widget.cda");
                this.saveAndClose(repoBase, Util.joinPath((String[])new String[]{"widgets", "sample.component.xml"}), sysPluginSamples, "widget.xml");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveAndClose(IRWAccess writer, String fileOut, IReadAccess reader, String fileIn) {
        InputStream input = null;
        try {
            input = reader.getFileInputStream(fileIn);
            boolean bl = CdeEngine.getEnv().getFileHandler().createBasicFileIfNotExists(writer, fileOut, input);
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)("Couldn't read " + fileIn + " in " + reader));
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return false;
    }

    private boolean ensureDirExists(IRWAccess access, String relPath, boolean isHidden) {
        return CdeEngine.getEnv().getFileHandler().createBasicDirIfNotExists(access, relPath, isHidden);
    }

    public static ICdeEnvironment getEnv() {
        return CdeEngine.getInstance().getEnvironment();
    }

    static {
        logger = LogFactory.getLog(CdeEngine.class);
    }
}

