/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.inst.CustomComponent;
import pt.webdetails.cdf.dd.model.inst.ExtensionPropertyBinding;
import pt.webdetails.cdf.dd.model.inst.Instance;
import pt.webdetails.cdf.dd.model.inst.PrimitiveComponent;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.VisualComponent;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.validation.ComponentDuplicatePropertyBindingError;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.packager.origin.OtherPluginStaticSystemOrigin;
import pt.webdetails.cpf.packager.origin.PluginRepositoryOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;

public abstract class Component<TM extends ComponentType>
extends Instance<TM> {
    private static final Log _logger = LogFactory.getLog(Component.class);
    private final String _idPrefix;
    private final String _name;
    private final Map<String, PropertyBinding> _propertyBindingsByLowerAlias;
    private final Map<String, PropertyBinding> _propertyBindingsByLowerName;
    private final List<ExtensionPropertyBinding> _extensionPropertyBindings;

    protected Component(Builder builder, MetaModel metaModel) throws ValidationException {
        super(builder);
        assert (metaModel != null);
        this._name = StringUtils.defaultIfEmpty((String)builder.tryGetComponentName(), (String)"");
        String string = this._idPrefix = builder._idPrefix == null ? this.initGetDefaultIdPrefix() : builder._idPrefix;
        if (this._name.isEmpty()) {
            _logger.warn((Object)("A component of type '" + this.getMeta().getName() + "' has no name."));
        }
        if (builder.getPropertyBindingCount() > 0) {
            this._propertyBindingsByLowerAlias = new LinkedHashMap<String, PropertyBinding>();
            this._propertyBindingsByLowerName = new LinkedHashMap<String, PropertyBinding>();
            this._extensionPropertyBindings = new ArrayList<ExtensionPropertyBinding>();
            for (PropertyBinding.Builder bindBuilder : builder.getPropertyBindings()) {
                PropertyBinding bind;
                try {
                    bind = bindBuilder.build(this, metaModel);
                }
                catch (ValidationException ex) {
                    _logger.warn((Object)ex.getError());
                    continue;
                }
                String propAlias = bind.getAlias().toLowerCase();
                if (this._propertyBindingsByLowerAlias.containsKey(propAlias)) {
                    _logger.warn((Object)new ComponentDuplicatePropertyBindingError(bind.getAlias(), this.getId(), this.getMeta().getLabel()));
                    continue;
                }
                String propName = bind.getName().toLowerCase();
                this._propertyBindingsByLowerAlias.put(propAlias, bind);
                this._propertyBindingsByLowerName.put(propName, bind);
                if (!(bind instanceof ExtensionPropertyBinding)) continue;
                this._extensionPropertyBindings.add((ExtensionPropertyBinding)bind);
            }
        } else {
            this._propertyBindingsByLowerAlias = null;
            this._propertyBindingsByLowerName = null;
            this._extensionPropertyBindings = null;
        }
    }

    protected String initGetDefaultIdPrefix() {
        return "";
    }

    public String buildId(String alias) {
        String unprefixedId = Component.composeIds(alias, this._name);
        String pprefix = StringUtils.defaultIfEmpty((String)this._idPrefix, (String)"");
        if (pprefix.length() > 0) {
            pprefix = pprefix + "_";
        }
        return pprefix + unprefixedId;
    }

    public static String composeIds(String alias, String localId) {
        String palias;
        String plocalId;
        String string = plocalId = StringUtils.isEmpty((String)localId) ? "" : localId.replace(" ", "_");
        if (plocalId.startsWith("Dashboards.storage")) {
            palias = "";
        } else {
            palias = StringUtils.defaultIfEmpty((String)alias, (String)"");
            if (palias.length() > 0) {
                palias = palias + "_";
            }
        }
        return palias + localId;
    }

    @Override
    public TM getMeta() {
        return (TM)((ComponentType)super.getMeta());
    }

    @Override
    public final String getId() {
        return this.buildId("");
    }

    public final String getIdPrefix() {
        return this._idPrefix;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public String getKind() {
        return "Component";
    }

    public PropertyBinding getPropertyBinding(String alias) {
        PropertyBinding propBind = this.tryGetPropertyBinding(alias);
        if (propBind == null) {
            throw new IllegalArgumentException("There is no property binding for alias '" + alias + "'.");
        }
        return propBind;
    }

    public PropertyBinding getPropertyBindingByName(String name) {
        PropertyBinding propBind = this.tryGetPropertyBindingByName(name);
        if (propBind == null) {
            throw new IllegalArgumentException("There is no property binding for name '" + name + "'.");
        }
        return propBind;
    }

    public String tryGetPropertyValueByName(String name, String defaultValue) {
        PropertyBinding bind = this.tryGetPropertyBindingByName(name);
        return bind == null ? defaultValue : StringUtils.defaultIfEmpty((String)bind.getValue(), (String)defaultValue);
    }

    public PropertyBinding tryGetPropertyBinding(String alias) {
        if (StringUtils.isEmpty((String)alias)) {
            throw new IllegalArgumentException("alias");
        }
        return this._propertyBindingsByLowerAlias.get(alias.toLowerCase());
    }

    public String tryGetPropertyValue(String alias, String defaultValue) {
        PropertyBinding bind = this.tryGetPropertyBinding(alias);
        return bind == null ? defaultValue : StringUtils.defaultIfEmpty((String)bind.getValue(), (String)defaultValue);
    }

    public PropertyBinding tryGetPropertyBindingByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name");
        }
        return this._propertyBindingsByLowerName.get(name.toLowerCase());
    }

    public Iterable<PropertyBinding> getPropertyBindings() {
        return this._propertyBindingsByLowerAlias != null ? this._propertyBindingsByLowerAlias.values() : Collections.emptyList();
    }

    public int getPropertyBindingCount() {
        return this._propertyBindingsByLowerAlias != null ? this._propertyBindingsByLowerAlias.size() : 0;
    }

    public final Iterable<ExtensionPropertyBinding> getExtensionPropertyBindings() {
        return this._extensionPropertyBindings != null ? this._extensionPropertyBindings : Collections.emptyList();
    }

    public int getExtensionPropertyBindingCount() {
        return this._extensionPropertyBindings != null ? this._extensionPropertyBindings.size() : 0;
    }

    public String getComponentClassName() {
        return Utils.getComponentClassName(this.getMeta().getName());
    }

    public boolean isPrimitiveComponent() {
        return this instanceof PrimitiveComponent;
    }

    public boolean isCustomComponent() {
        return this instanceof CustomComponent;
    }

    public boolean isVisualComponent() {
        return this instanceof VisualComponent;
    }

    public boolean isWidgetComponent() {
        return this instanceof WidgetComponent;
    }

    public boolean isComponentStaticSystemOrigin() {
        return ((ComponentType)this.getMeta()).getOrigin() instanceof StaticSystemOrigin;
    }

    public boolean isComponentPluginRepositoryOrigin() {
        return ((ComponentType)this.getMeta()).getOrigin() instanceof PluginRepositoryOrigin;
    }

    public boolean isComponentOtherPluginStaticSystemOrigin() {
        return ((ComponentType)this.getMeta()).getOrigin() instanceof OtherPluginStaticSystemOrigin;
    }

    public boolean supportsLegacy() {
        return ((ComponentType)this.getMeta()).supportsLegacy();
    }

    public String getComponentImplementationPath() {
        return ((ComponentType)this.getMeta()).getImplementationPath();
    }

    public String getComponentSourcePath() {
        return this.getMeta().getSourcePath();
    }

    public String getPluginIdFromOrigin() {
        return ((OtherPluginStaticSystemOrigin)((ComponentType)this.getMeta()).getOrigin()).getPluginId();
    }

    public static abstract class Builder
    extends Instance.Builder {
        private String _idPrefix;
        private List<PropertyBinding.Builder> _propBindings;

        public String getIdPrefix() {
            return this._idPrefix;
        }

        public Builder setIdPrefix(String idPrefix) {
            this._idPrefix = idPrefix;
            return this;
        }

        public Builder addPropertyBinding(PropertyBinding.Builder prop) {
            if (prop == null) {
                throw new IllegalArgumentException("prop");
            }
            if (this._propBindings == null) {
                this._propBindings = new ArrayList<PropertyBinding.Builder>();
            }
            this._propBindings.add(prop);
            return this;
        }

        public Iterable<PropertyBinding.Builder> getPropertyBindings() {
            return this._propBindings != null ? this._propBindings : Collections.emptyList();
        }

        public int getPropertyBindingCount() {
            return this._propBindings != null ? this._propBindings.size() : 0;
        }

        public String tryGetComponentName() {
            for (PropertyBinding.Builder bindBuilder : this.getPropertyBindings()) {
                if (!"name".equalsIgnoreCase(bindBuilder.getAlias())) continue;
                return bindBuilder.getValue();
            }
            return null;
        }

        public abstract Component build(MetaModel var1) throws ValidationException;
    }
}

