/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.legacy;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.ExtensionPropertyBinding;
import pt.webdetails.cdf.dd.model.inst.GenericComponent;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.meta.GenericComponentType;
import pt.webdetails.cdf.dd.model.meta.PropertyTypeUsage;
import pt.webdetails.cdf.dd.model.meta.VisualComponentType;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdfRunJsGenericComponentWriter
extends JsWriterAbstract
implements IThingWriter {
    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((StringBuilder)output, (CdfRunJsDashboardWriteContext)context, (GenericComponent)t);
    }

    public void write(StringBuilder out, CdfRunJsDashboardWriteContext context, GenericComponent comp) throws ThingWriteException {
        VisualComponentType compType = comp.getMeta();
        String id = context.getId(comp);
        out.append("var ").append(id).append(" = {").append(CdeConstants.Writer.NEWLINE);
        CdfRunJsGenericComponentWriter.addJsProperty(out, "type", JsonUtils.toJsString(compType.getName()), "  ", true);
        CdfRunJsGenericComponentWriter.addJsProperty(out, "name", JsonUtils.toJsString(id), "  ", false);
        for (String definitionName : compType.getDefinitionNames()) {
            CdfRunJsGenericComponentWriter.addCommaAndLineSep(out);
            this.writeDefinition(definitionName, out, context, comp, (GenericComponentType)compType);
        }
        out.append(CdeConstants.Writer.NEWLINE).append("};").append(CdeConstants.Writer.NEWLINE);
    }

    private void writeDefinition(String definitionName, StringBuilder out, CdfRunJsDashboardWriteContext context, GenericComponent comp, GenericComponentType compType) throws ThingWriteException {
        boolean isCCC;
        IThingWriter writer;
        String indent = "  ";
        boolean isDefaultDefinition = StringUtils.isEmpty((String)definitionName);
        if (!isDefaultDefinition) {
            CdfRunJsGenericComponentWriter.addJsProperty(out, definitionName, " {", "  ", true);
            indent = "    ";
        }
        CdfRunJsDashboardWriteContext childContext = context.withIndent(indent);
        childContext.setIsFirstInList(true);
        IThingWriterFactory factory = context.getFactory();
        for (PropertyTypeUsage propUsage : compType.getPropertiesByDefinition(definitionName)) {
            PropertyBinding propertyBinding;
            String propName = propUsage.getName();
            if (isDefaultDefinition && "name".equalsIgnoreCase(propName) || (propertyBinding = comp.tryGetPropertyBindingByName(propName)) == null) continue;
            try {
                writer = factory.getWriter(propertyBinding);
            }
            catch (UnsupportedThingException ex) {
                throw new ThingWriteException(ex);
            }
            if (!isDefaultDefinition && childContext.isFirstInList()) {
                out.append(CdeConstants.Writer.NEWLINE);
            }
            writer.write(out, childContext, propertyBinding);
        }
        if (comp.getExtensionPropertyBindingCount() > 0 && ((isCCC = compType.getName().startsWith("ccc")) ? !isDefaultDefinition : isDefaultDefinition)) {
            Iterable<ExtensionPropertyBinding> propBinds = comp.getExtensionPropertyBindings();
            for (ExtensionPropertyBinding extensionPropertyBinding : propBinds) {
                try {
                    writer = factory.getWriter(extensionPropertyBinding);
                }
                catch (UnsupportedThingException ex) {
                    throw new ThingWriteException(ex);
                }
                if (!isDefaultDefinition && childContext.isFirstInList()) {
                    out.append(CdeConstants.Writer.NEWLINE);
                }
                writer.write(out, childContext, extensionPropertyBinding);
            }
        }
        if (!isDefaultDefinition) {
            out.append(CdeConstants.Writer.NEWLINE).append("  ").append("}");
        }
    }
}

