/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.legacy;

import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.ParameterComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdfRunJsParameterComponentWriter
extends JsWriterAbstract
implements IThingWriter {
    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((StringBuilder)output, (CdfRunJsDashboardWriteContext)context, (ParameterComponent)t);
    }

    public void write(StringBuilder out, CdfRunJsDashboardWriteContext context, ParameterComponent comp) throws ThingWriteException {
        String name = JsonUtils.toJsString(context.getId(comp));
        String value = JsonUtils.toJsString(comp.tryGetPropertyValue("propertyValue", ""));
        String viewRole = JsonUtils.toJsString(comp.tryGetPropertyValue("parameterViewRole", "unused"));
        Boolean isBookmarkable = "true".equalsIgnoreCase(comp.tryGetPropertyValue("bookmarkable", null));
        CdfRunJsParameterComponentWriter.addSetParameterAssignment(out, name, value);
        if (isBookmarkable.booleanValue()) {
            CdfRunJsParameterComponentWriter.addBookmarkable(out, name);
        }
        CdfRunJsParameterComponentWriter.addViewMode(out, name, viewRole);
    }

    protected static void addSetParameterAssignment(StringBuilder out, String name, String value) {
        out.append("Dashboards.addParameter(").append(name).append(", ").append(value).append(");").append(CdeConstants.Writer.NEWLINE);
    }

    protected static void addViewMode(StringBuilder out, String name, String viewRole) {
        out.append("Dashboards.setParameterViewMode(").append(name).append(", ").append(viewRole).append(");").append(CdeConstants.Writer.NEWLINE);
    }

    protected static void addBookmarkable(StringBuilder out, String name) {
        out.append("Dashboards.setBookmarkable(").append(name).append(");").append(CdeConstants.Writer.NEWLINE);
    }
}

