/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public final class CdfRunJsDashboardWriteResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date _loadedDate;
    private final String _template;
    private final String _header;
    private final String _layout;
    private final String _components;
    private final String _content;
    private final String _footer;

    protected CdfRunJsDashboardWriteResult(Builder builder) {
        assert (builder != null);
        this._loadedDate = builder._loadedDate != null ? builder._loadedDate : new Date();
        this._template = StringUtils.defaultIfEmpty((String)builder._template, (String)"");
        this._header = StringUtils.defaultIfEmpty((String)builder._header, (String)"");
        this._layout = StringUtils.defaultIfEmpty((String)builder._layout, (String)"");
        this._components = StringUtils.defaultIfEmpty((String)builder._components, (String)"");
        this._content = StringUtils.defaultIfEmpty((String)builder._content, (String)"");
        this._footer = StringUtils.defaultIfEmpty((String)builder._footer, (String)"");
    }

    public Date getLoadedDate() {
        return this._loadedDate;
    }

    public String getTemplate() {
        return this._template;
    }

    public String getHeader() {
        return this._header;
    }

    public String getLayout() {
        return this._layout;
    }

    public String getComponents() {
        return this._components;
    }

    public String getContent() {
        return this.getContent("");
    }

    public String getContent(String contextConfiguration) {
        return this._content.replaceFirst("@CONTEXT_CONFIGURATION@", StringUtils.defaultIfEmpty((String)Matcher.quoteReplacement(contextConfiguration), (String)"{}"));
    }

    public String getFooter() {
        return this._footer;
    }

    public String render(String dashboardContext) {
        return this.render(dashboardContext, "");
    }

    public String render(String dashboardContext, String contextConfiguration) {
        return this.getTemplate().replaceAll("\\@HEADER\\@", Matcher.quoteReplacement(dashboardContext)).replaceFirst("@CONTEXT_CONFIGURATION@", StringUtils.defaultIfEmpty((String)Matcher.quoteReplacement(contextConfiguration), (String)"{}"));
    }

    public static class Builder {
        private String _template;
        private String _header;
        private String _layout;
        private String _components;
        private String _content;
        private String _footer;
        private Date _loadedDate;

        public String getTemplate() {
            return this._template;
        }

        public Builder setTemplate(String template) {
            this._template = template;
            return this;
        }

        public String getHeader() {
            return this._header;
        }

        public Builder setHeader(String header) {
            this._header = header;
            return this;
        }

        public String getLayout() {
            return this._layout;
        }

        public Builder setLayout(String layout) {
            this._layout = layout;
            return this;
        }

        public String getComponents() {
            return this._components;
        }

        public Builder setComponents(String components) {
            this._components = components;
            return this;
        }

        public String getContent() {
            return this._content;
        }

        public Builder setContent(String content) {
            this._content = content;
            return this;
        }

        public String getFooter() {
            return this._footer;
        }

        public Builder setFooter(String footer) {
            this._footer = footer;
            return this;
        }

        public Date getLoadedDate() {
            return this._loadedDate;
        }

        public Builder setLoadedDate(Date loadedDate) {
            this._loadedDate = loadedDate;
            return this;
        }

        public CdfRunJsDashboardWriteResult build() {
            return new CdfRunJsDashboardWriteResult(this);
        }
    }
}

