/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.amd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.amd.CdfRunJsDashboardWriter;
import pt.webdetails.cdf.dd.render.ResourceMap;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.Utils;

public class CdfRunJsDashboardModuleWriter
extends CdfRunJsDashboardWriter {
    protected static Log logger = LogFactory.getLog(CdfRunJsDashboardModuleWriter.class);

    public CdfRunJsDashboardModuleWriter(DashboardWcdfDescriptor.DashboardRendererType type) {
        super(type);
    }

    @Override
    public void write(CdfRunJsDashboardWriteResult.Builder builder, CdfRunJsDashboardWriteContext context, Dashboard dashboard) throws ThingWriteException {
        String layout;
        ResourceMap resources;
        assert (dashboard == context.getDashboard());
        try {
            JXPathContext layoutJXPContext = dashboard.getLayout("TODO").getLayoutXPContext();
            String aliasPrefix = context.getOptions().getAliasPrefix();
            resources = this.getResourceRenderer(layoutJXPContext, context).renderResources(aliasPrefix);
        }
        catch (Exception ex) {
            throw new ThingWriteException("Error rendering resources.", ex);
        }
        try {
            String cssResourcesContent = this.writeCssCodeResources(resources);
            String layoutContent = this.writeLayout(context, dashboard);
            layout = context.replaceTokensAndAlias(cssResourcesContent + layoutContent);
        }
        catch (Exception ex) {
            throw new ThingWriteException("Error rendering layout", ex);
        }
        StringBuilder out = new StringBuilder();
        String wcdfSettings = this.writeWcdfSettings(dashboard);
        Map<String, String> componentModules = this.writeComponents(context, dashboard, out);
        String components = this.replaceAliasTagWithAlias(context.replaceHtmlAlias(context.replaceTokens(out.toString())));
        String content = this.wrapRequireModuleDefinitions(layout, resources, componentModules, wcdfSettings + components, context);
        builder.setTemplate("").setHeader("").setLayout(layout).setComponents(components).setContent(content).setFooter("").setLoadedDate(context.getDashboard().getSourceDate());
    }

    protected String replaceAliasTagWithAlias(String content) {
        return content.replaceAll("@ALIAS@", "\" + this._alias +\"");
    }

    protected String wrapRequireModuleDefinitions(String layout, ResourceMap resources, Map<String, String> componentModules, String content, CdfRunJsDashboardWriteContext context) {
        StringBuilder output = new StringBuilder();
        ArrayList<String> moduleIds = new ArrayList<String>();
        ArrayList<String> moduleClassNames = new ArrayList<String>();
        this.addDefaultDashboardModules(moduleIds, moduleClassNames);
        for (Map.Entry<String, String> pair : componentModules.entrySet()) {
            moduleIds.add(pair.getValue());
            if (StringUtils.isEmpty((String)pair.getKey())) continue;
            moduleClassNames.add(pair.getKey());
        }
        Map<String, String> fileResourceModules = this.writeFileResourcesRequireJSPathConfig(output, resources, context);
        moduleIds.addAll(fileResourceModules.keySet());
        moduleClassNames.addAll(fileResourceModules.values());
        this.writeRequireJsExecutionFunction(output, moduleIds, moduleClassNames);
        String dashSourcePath = context.getDashboard().getSourcePath();
        String noNewlinesLayout = StringEscapeUtils.escapeJavaScript((String)layout.replace(CdeConstants.Writer.NEWLINE, ""));
        String aliasPrefix = context.getOptions().getAliasPrefix();
        if (aliasPrefix.contains("@ALIAS@")) {
            aliasPrefix = aliasPrefix.replace("@ALIAS@", "\" + this._alias + \"");
            output.append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_MODULE_START_EMPTY_ALIAS, noNewlinesLayout)).append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_MODULE_NORMALIZE_ALIAS, aliasPrefix)).append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_MODULE_GET_MESSAGES_PATH, this.getWcdfReposPath(dashSourcePath)));
        } else {
            output.append(CdeConstants.Writer.DASHBOARD_MODULE_START).append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_MODULE_LAYOUT, noNewlinesLayout)).append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_MODULE_NORMALIZE_ALIAS, aliasPrefix)).append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_MODULE_GET_MESSAGES_PATH, this.getWcdfReposPath(dashSourcePath)));
        }
        String jsCodeSnippets = this.writeJsCodeResources(resources);
        content = jsCodeSnippets.length() > 0 ? jsCodeSnippets + CdeConstants.Writer.NEWLINE + content : content;
        output.append(CdeConstants.Writer.DASHBOARD_MODULE_RENDERER).append(CdeConstants.Writer.NEWLINE).append(CdeConstants.Writer.DASHBOARD_MODULE_SETUP_DOM).append(CdeConstants.Writer.NEWLINE).append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_MODULE_PROCESS_COMPONENTS, content)).append("  });").append(CdeConstants.Writer.NEWLINE).append(CdeConstants.Writer.DEFINE_STOP);
        return output.toString();
    }

    @Override
    protected void writeRequireJsExecutionFunction(StringBuilder out, List<String> ids, List<String> classNames) {
        classNames.removeIf(StringUtils::isEmpty);
        out.append(MessageFormat.format(CdeConstants.Writer.DEFINE_START, StringUtils.join(ids, (String)"', '"), StringUtils.join(classNames, (String)", ")));
    }

    String getWcdfReposPath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return "undefined";
        }
        return "\"" + this.replaceCdfdeExtension(Utils.getWcdfReposPath(path)) + "/\"";
    }

    String replaceCdfdeExtension(String path) {
        if (path.endsWith(".cdfde")) {
            return path.substring(0, path.lastIndexOf(".cdfde")) + ".wcdf";
        }
        return path;
    }
}

