/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.amd;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.DataSourceComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.render.RenderLayout;
import pt.webdetails.cdf.dd.render.RenderResources;
import pt.webdetails.cdf.dd.render.Renderer;
import pt.webdetails.cdf.dd.render.ResourceMap;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.Util;

public class CdfRunJsDashboardWriter
extends JsWriterAbstract
implements IThingWriter {
    protected static final Log logger = LogFactory.getLog(CdfRunJsDashboardWriter.class);
    private DashboardWcdfDescriptor.DashboardRendererType type;

    public CdfRunJsDashboardWriter(DashboardWcdfDescriptor.DashboardRendererType type) {
        this.type = type;
    }

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((CdfRunJsDashboardWriteResult.Builder)output, (CdfRunJsDashboardWriteContext)context, (Dashboard)t);
    }

    public void write(CdfRunJsDashboardWriteResult.Builder builder, CdfRunJsDashboardWriteContext context, Dashboard dashboard) throws ThingWriteException {
        String template;
        String footer;
        String layout;
        ResourceMap resources;
        assert (dashboard == context.getDashboard());
        DashboardWcdfDescriptor wcdf = dashboard.getWcdf();
        String header = context.replaceTokens(this.writeHeaders(dashboard));
        try {
            JXPathContext layoutJXPContext = dashboard.getLayout("TODO").getLayoutXPContext();
            String aliasPrefix = context.getOptions().getAliasPrefix();
            resources = this.getResourceRenderer(layoutJXPContext, context).renderResources(aliasPrefix);
        }
        catch (Exception ex) {
            throw new ThingWriteException("Error rendering resources.", ex);
        }
        try {
            String cssCodeResourcesContent = this.writeCssCodeResources(resources);
            String layoutContent = this.writeLayout(context, dashboard);
            layout = context.replaceTokensAndAlias(cssCodeResourcesContent + layoutContent);
        }
        catch (Exception ex) {
            throw new ThingWriteException("Error rendering layout", ex);
        }
        StringBuilder out = new StringBuilder();
        String wcdfSettings = this.writeWcdfSettings(dashboard);
        Map<String, String> componentModules = this.writeComponents(context, dashboard, out);
        String components = context.replaceTokensAndAlias(out.toString());
        String content = this.writeContent(resources, layout, componentModules, wcdfSettings + components, context);
        try {
            footer = Util.toString((InputStream)CdeEnvironment.getPluginSystemReader().getFileInputStream("resources/patch-footer-require.html"));
        }
        catch (IOException ex) {
            throw new ThingWriteException("Could not read footer file.", ex);
        }
        try {
            template = context.replaceTokens(Utils.readTemplate(wcdf));
        }
        catch (IOException ex) {
            throw new ThingWriteException("Could not read style template file.", ex);
        }
        template = template.replaceAll("\\@HEADER\\@", Matcher.quoteReplacement(header) + "\\@HEADER\\@").replaceAll("\\@CONTENT\\@", Matcher.quoteReplacement(content)).replaceAll("\\@FOOTER\\@", Matcher.quoteReplacement(footer));
        builder.setHeader(header).setLayout(layout).setComponents(components).setContent(content).setFooter(footer).setTemplate(template).setLoadedDate(dashboard.getSourceDate());
    }

    protected String writeLayout(CdfRunJsDashboardWriteContext context, Dashboard dashboard) throws Exception {
        if (dashboard.getLayoutCount() > 0) {
            JXPathContext docXP = dashboard.getLayout("TODO").getLayoutXPContext();
            return this.getLayoutRenderer(docXP, context).render(context.getOptions().getAliasPrefix());
        }
        logger.warn((Object)"Unable to render layout: no layout found.");
        return "";
    }

    protected Renderer getLayoutRenderer(JXPathContext docXP, CdfRunJsDashboardWriteContext context) {
        return new RenderLayout(docXP, context, false);
    }

    protected String writeCssCodeResources(ResourceMap resources) {
        StringBuilder out = new StringBuilder();
        for (ResourceMap.Resource resource : resources.getCssResources()) {
            if (!this.isCodeResource(resource)) continue;
            out.append(resource.getProcessedResource()).append(CdeConstants.Writer.NEWLINE);
        }
        return out.toString();
    }

    protected String writeJsCodeResources(ResourceMap resources) {
        StringBuilder sb = new StringBuilder();
        for (ResourceMap.Resource resource : resources.getJavascriptResources()) {
            if (!this.isCodeResource(resource)) continue;
            sb.append(resource.getProcessedResource()).append(CdeConstants.Writer.NEWLINE);
        }
        return sb.toString();
    }

    protected RenderResources getResourceRenderer(JXPathContext docXP, CdfRunJsDashboardWriteContext context) {
        return new RenderResources(docXP, context);
    }

    protected String writeWcdfSettings(Dashboard dashboard) throws ThingWriteException {
        DashboardWcdfDescriptor wcdf = dashboard.getWcdf();
        try {
            return MessageFormat.format(CdeConstants.Writer.GET_WCDF_SETTINGS_FUNCTION, wcdf.toJSON().toString(6));
        }
        catch (JSONException ex) {
            throw new ThingWriteException("Converting wcdf to json", (Exception)((Object)ex));
        }
    }

    protected Map<String, String> writeComponents(CdfRunJsDashboardWriteContext context, Dashboard dashboard, StringBuilder out) throws ThingWriteException {
        IThingWriterFactory factory = context.getFactory();
        StringBuilder tmp = new StringBuilder();
        Iterable<DataSourceComponent> dataSourceComps = dashboard.getDataSources();
        for (DataSourceComponent comp : dataSourceComps) {
            IThingWriter writer;
            if (!StringUtils.isNotEmpty((String)comp.getName())) continue;
            try {
                writer = factory.getWriter(comp);
                tmp.setLength(0);
            }
            catch (UnsupportedThingException ex) {
                throw new ThingWriteException(ex);
            }
            out.append(MessageFormat.format("  dashboard.addDataSource(\"{0}\", ", comp.getName()));
            writer.write(tmp, context, comp);
            out.append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_ADD_DATA_SOURCE_END, tmp.toString()));
        }
        LinkedHashMap<String, String> componentModules = new LinkedHashMap<String, String>();
        tmp.setLength(0);
        Iterable<Component> comps = dashboard.getRegulars();
        for (Component comp : comps) {
            IThingWriter writer;
            if (!StringUtils.isNotEmpty((String)comp.getName())) continue;
            try {
                writer = factory.getWriter(comp);
            }
            catch (UnsupportedThingException ex) {
                throw new ThingWriteException(ex);
            }
            if (comp.isVisualComponent()) {
                String componentClassName;
                if ((comp.isCustomComponent() || comp.isPrimitiveComponent()) && !componentModules.containsKey(componentClassName = comp.getComponentClassName())) {
                    String componentModuleId = this.writeComponentModuleId(comp, componentClassName);
                    if (StringUtils.isEmpty((String)componentModuleId)) continue;
                    componentModules.put(componentClassName, componentModuleId);
                }
                if (tmp.length() > 0) {
                    tmp.append(", ");
                }
                tmp.append(comp.getId());
            }
            writer.write(out, context, comp);
        }
        if (tmp.length() > 0) {
            out.append(MessageFormat.format(CdeConstants.Writer.DASHBOARD_ADD_COMPONENTS, tmp.toString()));
        }
        return componentModules;
    }

    protected String writeComponentModuleId(Component comp, String className) {
        StringBuilder componentModuleId = new StringBuilder();
        if (comp.isPrimitiveComponent() && comp.isComponentStaticSystemOrigin()) {
            componentModuleId.append("cdf/components/").append(className);
        } else if (comp.isCustomComponent()) {
            if (comp.isComponentStaticSystemOrigin()) {
                componentModuleId.append("cde/components/").append(className);
            } else if (comp.isComponentPluginRepositoryOrigin()) {
                String compImplPath = comp.getComponentImplementationPath();
                compImplPath = comp.supportsLegacy() || StringUtils.isEmpty((String)compImplPath) ? comp.getComponentSourcePath().split("component.xml")[0] + className : compImplPath.substring(0, compImplPath.lastIndexOf(".js"));
                if (StringUtils.isEmpty((String)compImplPath)) {
                    logger.error((Object)("Missing an implementation code source path for component " + className));
                    return "";
                }
                componentModuleId.append("cde/repo/components/").append(compImplPath);
            } else if (comp.isComponentOtherPluginStaticSystemOrigin()) {
                componentModuleId.append(comp.getPluginIdFromOrigin()).append("/components/").append(className);
            }
        } else if (comp.isWidgetComponent()) {
            logger.error((Object)("Unsupported component: " + className));
            return "";
        }
        return componentModuleId.toString();
    }

    protected String writeHeaders(Dashboard dashboard) {
        return MessageFormat.format("  <title>{0}</title>", dashboard.getWcdf().getTitle()) + CdeConstants.Writer.NEWLINE + MessageFormat.format(CdeConstants.Writer.SCRIPT, this.writeWebcontext("cdf", true));
    }

    protected String writeWebcontext(String context, boolean requireJsOnly) {
        return MessageFormat.format("webcontext.js?context={0}&amp;requireJsOnly={1}&amp;application=pentaho-cdf", context, Boolean.toString(requireJsOnly).toLowerCase());
    }

    protected String writeContent(ResourceMap resources, String layout, Map<String, String> componentModules, String components, CdfRunJsDashboardWriteContext context) {
        StringBuilder out = new StringBuilder();
        out.append(layout);
        CdfRunJsDashboardWriter.wrapJsScriptTags(out, this.wrapRequireDefinitions(resources, componentModules, components, context));
        return out.toString();
    }

    protected String wrapRequireDefinitions(ResourceMap resources, Map<String, String> componentModules, String content, CdfRunJsDashboardWriteContext context) {
        StringBuilder out = new StringBuilder();
        ArrayList<String> moduleIds = new ArrayList<String>();
        ArrayList<String> moduleClassNames = new ArrayList<String>();
        this.addDefaultDashboardModules(moduleIds, moduleClassNames);
        for (Map.Entry<String, String> pair : componentModules.entrySet()) {
            moduleIds.add(pair.getValue());
            if (StringUtils.isEmpty((String)pair.getKey())) continue;
            moduleClassNames.add(pair.getKey());
        }
        Map<String, String> fileResourceModules = this.writeFileResourcesRequireJSPathConfig(out, resources, context);
        moduleIds.addAll(fileResourceModules.keySet());
        moduleClassNames.addAll(fileResourceModules.values());
        this.writeRequireJsExecutionFunction(out, moduleIds, moduleClassNames);
        if (context.getOptions().isDebug()) {
            out.append(CdeConstants.Writer.DASHBOARD_DECLARATION_DEBUG).append(CdeConstants.Writer.NEWLINE);
        } else {
            out.append(CdeConstants.Writer.DASHBOARD_DECLARATION).append(CdeConstants.Writer.NEWLINE);
        }
        out.append(this.writeJsCodeResources(resources));
        out.append(content).append(CdeConstants.Writer.NEWLINE).append(CdeConstants.Writer.DASHBOARD_INIT).append(CdeConstants.Writer.REQUIRE_STOP);
        return out.toString();
    }

    protected void addDefaultDashboardModules(ArrayList<String> moduleIds, ArrayList<String> moduleClassNames) {
        CdeConstants.AmdModule dashboardModule = this.getDashboardModule();
        moduleIds.add(dashboardModule.getId());
        moduleIds.add(CdeConstants.AmdModule.LOGGER.getId());
        moduleIds.add(CdeConstants.AmdModule.JQUERY.getId());
        moduleIds.add(CdeConstants.AmdModule.UNDERSCORE.getId());
        moduleIds.add(CdeConstants.AmdModule.MOMENT.getId());
        moduleIds.add(CdeConstants.AmdModule.CCC_CDO.getId());
        moduleIds.add(CdeConstants.AmdModule.CCC_DEF.getId());
        moduleIds.add(CdeConstants.AmdModule.CCC_PV.getId());
        moduleIds.add(CdeConstants.AmdModule.CCC_PVC.getId());
        moduleIds.add(CdeConstants.AmdModule.UTILS.getId());
        moduleClassNames.add(dashboardModule.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.LOGGER.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.JQUERY.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.UNDERSCORE.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.MOMENT.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.CCC_CDO.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.CCC_DEF.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.CCC_PV.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.CCC_PVC.getClassName());
        moduleClassNames.add(CdeConstants.AmdModule.UTILS.getClassName());
    }

    protected void writeRequireJsExecutionFunction(StringBuilder out, List<String> ids, List<String> classNames) {
        Iterator<String> i = classNames.iterator();
        while (i.hasNext()) {
            String className = i.next();
            if (!StringUtils.isEmpty((String)className)) continue;
            i.remove();
        }
        out.append(MessageFormat.format(CdeConstants.Writer.REQUIRE_START, StringUtils.join(ids, (String)("'," + CdeConstants.Writer.NEWLINE + "  " + "'")), StringUtils.join(classNames, (String)("," + CdeConstants.Writer.NEWLINE + "  ")))).append(CdeConstants.Writer.NEWLINE);
    }

    protected CdeConstants.AmdModule getDashboardModule() {
        DashboardWcdfDescriptor.DashboardRendererType dashboardType = this.getType();
        if (dashboardType.equals((Object)DashboardWcdfDescriptor.DashboardRendererType.BLUEPRINT)) {
            return CdeConstants.AmdModule.DASHBOARD_BLUEPRINT;
        }
        if (dashboardType.equals((Object)DashboardWcdfDescriptor.DashboardRendererType.BOOTSTRAP)) {
            return CdeConstants.AmdModule.DASHBOARD_BOOTSTRAP;
        }
        if (dashboardType.equals((Object)DashboardWcdfDescriptor.DashboardRendererType.MOBILE)) {
            return CdeConstants.AmdModule.DASHBOARD_MOBILE;
        }
        return CdeConstants.AmdModule.DASHBOARD_CLEAN;
    }

    public DashboardWcdfDescriptor.DashboardRendererType getType() {
        return this.type;
    }

    protected Map<String, String> writeFileResourcesRequireJSPathConfig(StringBuilder out, ResourceMap resources, CdfRunJsDashboardWriteContext context) {
        String resourceId;
        LinkedHashMap<String, String> resourceModules = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> unnamedResourceModules = new LinkedHashMap<String, String>();
        for (ResourceMap.Resource resource : resources.getJavascriptResources()) {
            if (!this.isFileResource(resource)) continue;
            resourceId = this.writeResource(out, context, resource);
            String name = resource.getResourceName();
            if (StringUtils.isEmpty((String)name)) {
                unnamedResourceModules.put(resourceId, name);
                continue;
            }
            resourceModules.put(resourceId, name);
        }
        for (ResourceMap.Resource resource : resources.getCssResources()) {
            if (!this.isFileResource(resource)) continue;
            resourceId = this.writeResource(out, context, resource);
            resourceModules.put((Object)((Object)CdeConstants.RequireJSPlugin.CSS) + resourceId, "");
        }
        if (out.length() > 0) {
            out.append("require.config(requireCfg);").append(CdeConstants.Writer.NEWLINE);
        }
        resourceModules.putAll(unnamedResourceModules);
        return resourceModules;
    }

    protected String getRandomUUID() {
        return UUID.randomUUID().toString();
    }

    protected ArrayList<String> getJsModuleClassNames(ResourceMap resources) {
        ArrayList<String> classNames = new ArrayList<String>();
        for (ResourceMap.Resource resource : resources.getJavascriptResources()) {
            String className;
            if (!this.isFileResource(resource) || StringUtils.isEmpty((String)(className = this.getModuleClassName(resource.getResourceName())))) continue;
            classNames.add(className);
        }
        return classNames;
    }

    private String getModuleClassName(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return "";
        }
        for (CdeConstants.RequireJSPlugin plugin : CdeConstants.RequireJSPlugin.values()) {
            className = className.replace(plugin.toString(), "").replace("cde/resources/", "");
        }
        return className;
    }

    private String writeResource(StringBuilder out, CdfRunJsDashboardWriteContext context, ResourceMap.Resource resource) {
        StringBuilder id;
        String path = context.replaceTokensAndAlias(resource.getResourcePath());
        if (CdeConstants.Writer.SCHEME_PATTERN.matcher(path = FilenameUtils.removeExtension((String)path).replaceAll(" ", "%20")).find()) {
            id = this.getResourceId(resource.getResourceName());
            String requireJSConfig = MessageFormat.format("requireCfg[''paths''][''{0}''] = ''{1}'';", id, path);
            out.append(requireJSConfig).append(CdeConstants.Writer.NEWLINE);
        } else {
            if ((path = Util.normalizeUri((String)path)).startsWith("/")) {
                path = path.replaceFirst("/", "");
            }
            id = this.getResourceId(path);
        }
        return id.toString();
    }

    private StringBuilder getResourceId(String name) {
        StringBuilder id = new StringBuilder("cde/resources");
        name = StringUtils.isEmpty((String)name) ? this.getRandomUUID() : name.replaceAll(" ", "%20");
        return id.append("/").append(name);
    }

    private boolean isFileResource(ResourceMap.Resource resource) {
        return resource.getResourceType().equals((Object)ResourceMap.ResourceType.FILE);
    }

    private boolean isCodeResource(ResourceMap.Resource resource) {
        return resource.getResourceType().equals((Object)ResourceMap.ResourceType.CODE);
    }
}

