/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.amd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;

public class PentahoCdfRunJsDashboardWriteContext
extends CdfRunJsDashboardWriteContext {
    private static final String SIMPLE_TOKEN = "\\$\\{(\\w+)\\}";
    private static final String RESOURCE_TOKEN = "\\$\\{(\\w+):((/?)(.+?)(/?))\\}";
    static final String DASH_PATH_TAG = "dashboardPath";
    static final String SYSTEM_TAG = "system";
    static final String IMAGE_TAG = "img";
    static final String RES_TAG = "res";
    static final String SOLUTION_TAG = "solution";

    public PentahoCdfRunJsDashboardWriteContext(IThingWriterFactory factory, String indent, boolean bypassCacheRead, Dashboard dash, CdfRunJsDashboardWriteOptions options) {
        super(factory, indent, bypassCacheRead, dash, options);
    }

    public PentahoCdfRunJsDashboardWriteContext(CdfRunJsDashboardWriteContext factory, String indent) {
        super(factory, indent);
    }

    @Override
    public String replaceTokens(String content) {
        Matcher simpleMatch = Pattern.compile(SIMPLE_TOKEN).matcher(content);
        while (simpleMatch.find()) {
            content = this.replaceToken(content, simpleMatch, this.getSimpleTokenReplacement(simpleMatch));
        }
        Matcher resourceMatch = Pattern.compile(RESOURCE_TOKEN).matcher(content);
        while (resourceMatch.find()) {
            content = this.replaceToken(content, resourceMatch, this.getResourceTokenReplacement(resourceMatch));
        }
        return content;
    }

    private String getSimpleTokenReplacement(Matcher token) {
        if (this.isDashboardPathTag(token)) {
            return this.getDashboardPathReplacement();
        }
        return null;
    }

    private String getDashboardPathReplacement() {
        String dashboardPath = this.getDashboardSourcePath().replaceAll("(^/.*/$)", "$1");
        return this.replaceWhiteSpaces(dashboardPath);
    }

    private boolean isDashboardPathTag(Matcher token) {
        return DASH_PATH_TAG.equals(token.group(1));
    }

    private String getResourceTokenReplacement(Matcher resource) {
        if (this.isSystemTag(resource)) {
            return this.getResourceReplacement(resource, this.getSystemRoot());
        }
        if (this.isImageTag(resource)) {
            return this.getResourceReplacement(resource, this.getPentahoResourceEndpoint()) + "?v=" + this.getWriteDate().getTime();
        }
        if (this.isResourceTag(resource)) {
            return this.getResourceReplacement(resource, "");
        }
        return null;
    }

    private String getResourceReplacement(Matcher tagMatcher, String absoluteRoot) {
        StringBuilder replacedContent = new StringBuilder(absoluteRoot);
        if (!this.isSystemTag(tagMatcher)) {
            replacedContent.append(this.isRelativeResource(tagMatcher) ? this.getDashboardSourcePath() : "");
        }
        replacedContent.append(this.getResourcePath(tagMatcher));
        return this.replaceWhiteSpaces(replacedContent.toString());
    }

    private String getResourcePath(Matcher resource) {
        String path = resource.group(2);
        if (this.isSystemTag(resource)) {
            path = path.replaceFirst("^/", "");
        }
        return path;
    }

    private boolean isImageTag(Matcher resource) {
        return IMAGE_TAG.equals(resource.group(1));
    }

    private boolean isSystemTag(Matcher resource) {
        return SYSTEM_TAG.equals(resource.group(1));
    }

    private boolean isResourceTag(Matcher resource) {
        String tag = resource.group(1);
        return SOLUTION_TAG.equals(tag) || RES_TAG.equals(tag);
    }

    private boolean isRelativeResource(Matcher resource) {
        return !"/".equals(resource.group(3));
    }

    private String replaceToken(String content, Matcher match, String replacement) {
        if (replacement != null) {
            content = content.substring(0, match.start()) + replacement + content.substring(match.end());
        }
        return content;
    }

    private String getSystemRoot() {
        String pluginId = this.getSystemPluginId();
        if (StringUtils.isEmpty((String)pluginId)) {
            pluginId = "";
        }
        return this.getPentahoResourceEndpoint() + "/" + this.getSystemDir() + "/" + pluginId + "/";
    }
}

