/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.legacy;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.VisualComponent;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.render.DependenciesManager;
import pt.webdetails.cdf.dd.render.RenderLayout;
import pt.webdetails.cdf.dd.render.Renderer;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.packager.StringFilter;

public class CdfRunJsDashboardWriter
extends JsWriterAbstract
implements IThingWriter {
    protected static final Log logger = LogFactory.getLog(CdfRunJsDashboardWriter.class);
    private DashboardWcdfDescriptor.DashboardRendererType type;

    public CdfRunJsDashboardWriter(DashboardWcdfDescriptor.DashboardRendererType type) {
        this.type = type;
    }

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((CdfRunJsDashboardWriteResult.Builder)output, (CdfRunJsDashboardWriteContext)context, (Dashboard)t);
    }

    public DashboardWcdfDescriptor.DashboardRendererType getType() {
        return this.type;
    }

    public void write(CdfRunJsDashboardWriteResult.Builder builder, CdfRunJsDashboardWriteContext ctx, Dashboard dash) throws ThingWriteException {
        String footer;
        String template;
        assert (dash == ctx.getDashboard());
        DashboardWcdfDescriptor wcdf = dash.getWcdf();
        try {
            template = Utils.readTemplate(wcdf);
        }
        catch (IOException ex) {
            throw new ThingWriteException("Could not read style template file.", ex);
        }
        template = ctx.replaceTokens(template);
        try {
            footer = Util.toString((InputStream)CdeEnvironment.getPluginSystemReader().getFileInputStream("resources/patch-footer.html"));
        }
        catch (IOException ex) {
            throw new ThingWriteException("Could not read footer file.", ex);
        }
        String layout = ctx.replaceTokensAndAlias(this.writeLayout(ctx, dash));
        String components = ctx.replaceTokensAndAlias(this.writeComponents(ctx, dash));
        String content = this.writeContent(layout, components);
        String header = ctx.replaceTokens(this.writeHeaders(content, ctx));
        template = template.replaceAll("\\@HEADER\\@", Matcher.quoteReplacement(header) + "\\@HEADER\\@").replaceAll("\\@FOOTER\\@", Matcher.quoteReplacement(footer)).replaceAll("\\@CONTENT\\@", Matcher.quoteReplacement(content));
        builder.setTemplate(template).setHeader(header).setLayout(layout).setComponents(components).setContent(content).setFooter(footer).setLoadedDate(ctx.getDashboard().getSourceDate());
    }

    protected String writeLayout(CdfRunJsDashboardWriteContext context, Dashboard dash) {
        if (dash.getLayoutCount() == 1) {
            JXPathContext docXP = dash.getLayout("TODO").getLayoutXPContext();
            try {
                return this.getLayoutRenderer(docXP, context).render(context.getOptions().getAliasPrefix());
            }
            catch (Exception ex) {
                logger.error((Object)"Error rendering layout", (Throwable)ex);
            }
        }
        return "";
    }

    protected Renderer getLayoutRenderer(JXPathContext docXP, CdfRunJsDashboardWriteContext context) {
        return new RenderLayout(docXP, context);
    }

    protected String writeComponents(CdfRunJsDashboardWriteContext context, Dashboard dash) throws ThingWriteException {
        DashboardWcdfDescriptor wcdf = dash.getWcdf();
        StringBuilder out = new StringBuilder();
        StringBuilder widgetsOut = new StringBuilder();
        try {
            CdfRunJsDashboardWriter.addAssignment(out, "wcdfSettings", wcdf.toJSON().toString(2));
        }
        catch (JSONException ex) {
            throw new ThingWriteException("Converting wcdf to json", (Exception)((Object)ex));
        }
        out.append(CdeConstants.Writer.NEWLINE);
        boolean isFirstComp = true;
        StringBuilder addCompIds = new StringBuilder();
        boolean isFirstAddComp = true;
        IThingWriterFactory factory = context.getFactory();
        Iterable<Component> comps = dash.getRegulars();
        for (Component comp : comps) {
            StringBuilder out2;
            IThingWriter writer;
            if (!StringUtils.isNotEmpty((String)comp.getName())) continue;
            try {
                writer = factory.getWriter(comp);
            }
            catch (UnsupportedThingException ex) {
                throw new ThingWriteException(ex);
            }
            boolean isWidget = comp instanceof WidgetComponent;
            StringBuilder stringBuilder = out2 = isWidget ? widgetsOut : out;
            if (!isFirstComp) {
                out2.append(CdeConstants.Writer.NEWLINE);
            }
            if (comp instanceof VisualComponent && !(comp instanceof WidgetComponent)) {
                if (isFirstAddComp) {
                    isFirstAddComp = false;
                } else {
                    addCompIds.append(", ");
                }
                addCompIds.append(context.getId(comp));
            }
            writer.write(out2, context, comp);
            isFirstComp = false;
        }
        if (!isFirstAddComp) {
            out.append(CdeConstants.Writer.NEWLINE);
            out.append("Dashboards.addComponents([");
            out.append((CharSequence)addCompIds);
            out.append("]);");
            out.append(CdeConstants.Writer.NEWLINE);
        }
        out.append((CharSequence)widgetsOut);
        return out.toString();
    }

    protected String writeHeaders(String contents, CdfRunJsDashboardWriteContext context) {
        String cdfDeps;
        CdfRunJsDashboardWriteOptions options = context.getOptions();
        DashboardWcdfDescriptor wcdf = context.getDashboard().getWcdf();
        String title = MessageFormat.format("  <title>{0}</title>", wcdf.getTitle());
        try {
            cdfDeps = CdeEngine.getEnv().getCdfIncludes(contents, this.getType().getType(), options.isDebug(), options.isAbsolute(), options.getAbsRoot(), options.getScheme());
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get cdf includes");
            cdfDeps = "";
        }
        final String baseUrl = options.isAbsolute() ? (!StringUtils.isEmpty((String)options.getAbsRoot()) ? options.getSchemedRoot() + "/" : CdeEngine.getInstance().getEnvironment().getUrlProvider().getWebappContextRoot()) : "";
        StringFilter cssFilter = new StringFilter(){

            public String filter(String input) {
                return this.filter(input, baseUrl);
            }

            public String filter(String input, String baseUrl2) {
                return MessageFormat.format(CdeConstants.Writer.STYLE, CdfRunJsDashboardWriter.this.joinUrls(baseUrl2, input));
            }
        };
        StringFilter jsFilter = new StringFilter(){

            public String filter(String input) {
                return this.filter(input, baseUrl);
            }

            public String filter(String input, String baseUrl2) {
                return MessageFormat.format(CdeConstants.Writer.SCRIPT, CdfRunJsDashboardWriter.this.joinUrls(baseUrl2, input));
            }
        };
        DependenciesManager depMgr = DependenciesManager.getInstance();
        boolean isPackaged = !options.isDebug();
        String scriptDeps = depMgr.getPackage("CDF").getDependencies(jsFilter, isPackaged);
        String styleDeps = depMgr.getPackage("CDF-CSS").getDependencies(cssFilter, isPackaged);
        String rawDeps = depMgr.getPackage("CDF-RAW").getRawDependencies(false);
        return title + cdfDeps + rawDeps + scriptDeps + styleDeps;
    }

    protected String joinUrls(String baseUrl, String url) {
        return baseUrl + (baseUrl.endsWith("/") && url.startsWith("/") ? url.replaceFirst("/", "") : url);
    }

    private String writeContent(String layout, String components) {
        StringBuilder out = new StringBuilder();
        out.append(layout);
        CdfRunJsDashboardWriter.wrapJsScriptTags(out, components + CdeConstants.Writer.NEWLINE + "Dashboards.init();");
        return out.toString();
    }
}

