/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.legacy;

import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.inst.CodeComponent;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.GenericComponent;
import pt.webdetails.cdf.dd.model.inst.ParameterComponent;
import pt.webdetails.cdf.dd.model.inst.PropertyBinding;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.CdfRunJsCodeComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.legacy.CdfRunJsDateParameterComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.legacy.CdfRunJsExpressionParameterComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.legacy.CdfRunJsGenericComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.legacy.CdfRunJsParameterComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.legacy.CdfRunJsWidgetComponentWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.legacy.CdfRunJsDashboardWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsCdaDataSourcePropertyBindingWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsDataSourcePropertyBindingWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsGenericPropertyBindingWriter;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.properties.CdfRunJsJFreeChartDataSourcePropertyBindingWriter;

public class CdfRunJsThingWriterFactory
implements IThingWriterFactory {
    @Override
    public IThingWriter getWriter(Thing t) throws UnsupportedThingException {
        if (t == null) {
            throw new IllegalArgumentException("t");
        }
        String kind = t.getKind();
        if ("Component".equals(kind)) {
            return this.getComponentWriter(t);
        }
        if ("PropertyBinding".equals(kind)) {
            return this.getPropertyBindingWriter(t);
        }
        if ("Dashboard".equals(kind)) {
            return this.getDashboardWriter((Dashboard)t);
        }
        throw new UnsupportedThingException(kind, t.getId());
    }

    public CdfRunJsDashboardWriter getDashboardWriter(Dashboard dashboard) {
        return new CdfRunJsDashboardWriter(dashboard.getWcdf().getParsedRendererType());
    }

    private IThingWriter getComponentWriter(Thing t) {
        Class<?> compClass = t.getClass();
        if (GenericComponent.class.isAssignableFrom(compClass)) {
            if (WidgetComponent.class.isAssignableFrom(compClass)) {
                return new CdfRunJsWidgetComponentWriter();
            }
            return new CdfRunJsGenericComponentWriter();
        }
        if (ParameterComponent.class.isAssignableFrom(compClass)) {
            return this.getParameterWriter(t);
        }
        if (CodeComponent.class.isAssignableFrom(compClass)) {
            return new CdfRunJsCodeComponentWriter();
        }
        return null;
    }

    private IThingWriter getParameterWriter(Thing t) {
        CdfRunJsParameterComponentWriter parameterWriter;
        String typeName;
        ParameterComponent paramComp = (ParameterComponent)t;
        switch (typeName = paramComp.getMeta().getName().toLowerCase()) {
            case "parameter": 
            case "olapparameter": {
                parameterWriter = new CdfRunJsParameterComponentWriter();
                break;
            }
            case "dateparameter": {
                parameterWriter = new CdfRunJsDateParameterComponentWriter();
                break;
            }
            case "javascriptparameter": {
                parameterWriter = new CdfRunJsExpressionParameterComponentWriter();
                break;
            }
            default: {
                parameterWriter = null;
            }
        }
        return parameterWriter;
    }

    private IThingWriter getPropertyBindingWriter(Thing t) {
        PropertyBinding propBind = (PropertyBinding)t;
        String propName = propBind.getName().toLowerCase();
        if (propName.equals("datasource")) {
            return new CdfRunJsDataSourcePropertyBindingWriter();
        }
        if (propName.equals("cdadatasource")) {
            return new CdfRunJsCdaDataSourcePropertyBindingWriter();
        }
        if (propName.equals("jfreechartdatasource")) {
            return new CdfRunJsJFreeChartDataSourcePropertyBindingWriter();
        }
        return new CdfRunJsGenericPropertyBindingWriter();
    }
}

