/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.model.core.validation.RequiredAttributeError;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cpf.packager.origin.PathOrigin;

public final class Resource {
    private final String name;
    private final String app;
    private final String version;
    private final String source;
    private final Type type;
    private final PathOrigin origin;

    private Resource(Builder builder) throws ValidationException {
        assert (builder != null);
        if (StringUtils.isEmpty((String)builder._source)) {
            throw new ValidationException(new RequiredAttributeError("Source"));
        }
        if (builder._type == null) {
            throw new ValidationException(new RequiredAttributeError("Type"));
        }
        this.name = StringUtils.defaultIfEmpty((String)builder._name, (String)builder._source);
        this.app = StringUtils.defaultIfEmpty((String)builder._app, (String)"");
        this.source = builder._source;
        this.version = StringUtils.defaultIfEmpty((String)builder._version, (String)"1.0");
        this.type = builder._type;
        this.origin = builder.origin;
    }

    public static String buildKey(Type type, String name) {
        return (Object)((Object)type) + "|" + (name == null ? "" : name);
    }

    public String getKey() {
        return Resource.buildKey(this.type, this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSource() {
        return this.source;
    }

    public Type getType() {
        return this.type;
    }

    public String getApp() {
        return this.app;
    }

    public PathOrigin getOrigin() {
        return this.origin;
    }

    public static final class Builder {
        private String _name;
        private String _version;
        private String _source;
        private Type _type;
        private String _app;
        private PathOrigin origin;

        public String getName() {
            return this._name;
        }

        public Builder setName(String name) {
            this._name = name;
            return this;
        }

        public String getVersion() {
            return this._version;
        }

        public Builder setVersion(String version) {
            this._version = version;
            return this;
        }

        public String getSource() {
            return this._source;
        }

        public Builder setSource(String source) {
            this._source = source;
            return this;
        }

        public Type getType() {
            return this._type;
        }

        public Builder setType(Type type) {
            this._type = type;
            return this;
        }

        public String getApp() {
            return this._app;
        }

        public Builder setApp(String app) {
            this._app = app;
            return this;
        }

        public Builder setOrigin(PathOrigin origin) {
            this.origin = origin;
            return this;
        }

        public Resource build() throws ValidationException {
            return new Resource(this);
        }
    }

    public static enum Type {
        SCRIPT,
        RAW,
        STYLE;

    }
}

