/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.reader.cdexml;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.reader.IThingReadContext;
import pt.webdetails.cdf.dd.model.core.reader.IThingReader;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.util.Utils;

public class XmlPropertyTypeReader
implements IThingReader {
    protected static final Log _logger = LogFactory.getLog(XmlPropertyTypeReader.class);

    public PropertyType.Builder read(Element source, String sourcePath) {
        PropertyType.Builder builder = new PropertyType.Builder();
        this.read(builder, null, source, sourcePath);
        return builder;
    }

    @Override
    public PropertyType.Builder read(IThingReadContext contextNotUsed, Object source, String sourcePath) throws ThingReadException {
        PropertyType.Builder builder = new PropertyType.Builder();
        this.read(builder, contextNotUsed, (Element)source, sourcePath);
        return builder;
    }

    @Override
    public void read(Thing.Builder builder, IThingReadContext contextNotUsed, Object source, String sourcePath) throws ThingReadException {
        this.read((PropertyType.Builder)builder, null, (Element)source, sourcePath);
    }

    public void read(PropertyType.Builder builder, IThingReadContext contextNotUsed, Element propertyElem, String sourcePath) throws IllegalArgumentException {
        String rendererKind;
        String order;
        String valueTypeText;
        String name = Utils.getNodeText("Header/Name", (Node)propertyElem, "");
        builder.setSourcePath(sourcePath).setName(name).setLabel(Utils.getNodeText("Header/Description", (Node)propertyElem)).setTooltip(Utils.getNodeText("Header/Tooltip", (Node)propertyElem));
        String advanced = Utils.getNodeText("Header/Advanced", (Node)propertyElem);
        if ("true".equalsIgnoreCase(advanced)) {
            builder.setCategory("advanced");
            builder.setCategoryLabel("Advanced");
        }
        builder.setBase(Utils.getNodeText("Header/Parent", (Node)propertyElem)).setDefaultValue(Utils.getNodeText("Header/DefaultValue", (Node)propertyElem)).setVersion(Utils.getNodeText("Header/Version", (Node)propertyElem));
        String visibleText = Utils.getNodeText("Header/Visible", (Node)propertyElem);
        if (StringUtils.isNotEmpty((String)visibleText)) {
            builder.setVisible("true".equalsIgnoreCase(visibleText));
        }
        if (StringUtils.isNotEmpty((String)(valueTypeText = Utils.getNodeText("Header/OutputType", (Node)propertyElem)))) {
            try {
                builder.setValueType(PropertyType.ValueType.valueOf(valueTypeText.toUpperCase()));
            }
            catch (IllegalArgumentException ex) {
                _logger.warn((Object)("PropertyType '" + name + "' in file '" + sourcePath + "' has an invalid 'OutputType' value: '" + valueTypeText + "'."), (Throwable)ex);
            }
        }
        if (StringUtils.isNotEmpty((String)(order = Utils.getNodeText("Header/Order", (Node)propertyElem)))) {
            try {
                int orderInt = Integer.parseInt(order);
                if (orderInt < 0) {
                    orderInt = 0;
                }
                builder.setOrder(orderInt);
            }
            catch (NumberFormatException ex) {
                _logger.warn((Object)("PropertyType '" + name + "' in file '" + sourcePath + "' has an invalid 'Order' value: '" + order + "'."), (Throwable)ex);
            }
        }
        if (StringUtils.isEmpty((String)(rendererKind = Utils.getNodeText("Header/InputType/@type", (Node)propertyElem))) || "custom".equalsIgnoreCase(rendererKind)) {
            builder.setInputType(Utils.getNodeText("Header/InputType", (Node)propertyElem));
        } else if ("valuelist".equalsIgnoreCase(rendererKind) || "dynamiclist".equalsIgnoreCase(rendererKind)) {
            String baseRendererType = Utils.getNodeText("Header/InputType/@base", (Node)propertyElem);
            if (StringUtils.isEmpty((String)baseRendererType)) {
                baseRendererType = "SelectRenderer";
            }
            builder.addAttribute("BaseRenderer", baseRendererType);
        } else {
            throw new IllegalArgumentException("PropertyType '" + name + "' in file '" + sourcePath + "' has an invalid 'Header/InputType/@type' value: '" + rendererKind + "'.");
        }
        builder.setPossibleValuesSource(Utils.getNodeText("Values/@source", (Node)propertyElem));
        List<Element> labeledValueElems = Utils.selectElements(propertyElem, "Values/Value");
        for (Element labeledValueElem : labeledValueElems) {
            builder.addPossibleValue(Utils.getNodeText(".", (Node)labeledValueElem), Utils.getNodeText("@display", (Node)labeledValueElem));
        }
    }
}

