/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.reader.datasources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.meta.DataSourceComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cpf.packager.origin.OtherPluginStaticSystemOrigin;
import pt.webdetails.cpf.packager.origin.PathOrigin;

public final class DataSourcesModelReader {
    protected static final Log logger = LogFactory.getLog(DataSourcesModelReader.class);

    public void read(MetaModel.Builder model, JSONObject cdaDefs, String sourcePath) throws ThingReadException {
        JXPathContext doc;
        assert (model != null);
        logger.info((Object)("Loading data source components of '" + sourcePath + "'"));
        try {
            doc = JsonUtils.toJXPathContext(cdaDefs);
        }
        catch (JSONException e) {
            throw new ThingReadException("Couldn't get JXPathContext from json", (Exception)((Object)e));
        }
        Iterator pointers = doc.iteratePointers("*");
        while (pointers.hasNext()) {
            Pointer pointer = (Pointer)pointers.next();
            this.readDataSourceComponent(model, pointer, sourcePath);
        }
    }

    private void readDataSourceComponent(MetaModel.Builder model, Pointer pointer, String sourcePath) {
        DataSourceComponentType.Builder builder = new DataSourceComponentType.Builder();
        Map def = (Map)pointer.getNode();
        JXPathContext jctx = JXPathContext.newContext((Object)def);
        String name = pointer.asPath().replaceAll(".*name='(.*?)'.*", "$1");
        String label = (String)jctx.getValue("metadata/name");
        String category = (String)jctx.getValue("metadata/group");
        String categoryLabel = (String)jctx.getValue("metadata/groupdesc");
        String dataSourceType = (String)jctx.getValue("metadata/datype");
        boolean isCPK = dataSourceType.equalsIgnoreCase("cpk");
        OtherPluginStaticSystemOrigin origin = new OtherPluginStaticSystemOrigin(isCPK ? "cpk" : "cda", "");
        builder.setOrigin((PathOrigin)origin);
        logger.debug((Object)String.format("\t%s", label));
        builder.setName(name).setLabel(label).setTooltip(label).setCategory(category).setCategoryLabel(categoryLabel).setSourcePath(sourcePath).addAttribute("", isCPK ? "CPK" : "CDA");
        if (isCPK) {
            this.readCPKDataSourceComponent(builder, jctx);
        } else {
            this.readCDADataSourceComponent(builder, jctx);
        }
        model.addComponent(builder);
    }

    private void readCDADataSourceComponent(DataSourceComponentType.Builder builder, JXPathContext jctx) {
        String label = (String)jctx.getValue("metadata/name");
        String dataSourceType = (String)jctx.getValue("metadata/datype");
        String connectionType = (String)jctx.getValue("metadata/conntype");
        connectionType = connectionType != null ? connectionType : "";
        builder.addAttribute("conntype", connectionType).addAttribute("datype", dataSourceType);
        for (String cdaPropName : this.getCDAPropertyNames(jctx)) {
            if (cdaPropName.equals("id") || cdaPropName.equals("connection")) continue;
            if (cdaPropName.equals("columns")) {
                builder.useProperty(null, "cdacolumns");
                builder.useProperty(null, "cdacalculatedcolumns");
                continue;
            }
            if (cdaPropName.equals("output")) {
                builder.useProperty(null, "output");
                builder.useProperty(null, "outputMode");
                continue;
            }
            if (cdaPropName.equals("left")) {
                builder.useProperty(null, "left");
                builder.useProperty(null, "leftkeys");
                continue;
            }
            if (cdaPropName.equals("right")) {
                builder.useProperty(null, "right");
                builder.useProperty(null, "rightkeys");
                continue;
            }
            if (this.isKettleOverX(label) && cdaPropName.equalsIgnoreCase("query")) {
                builder.useProperty(cdaPropName, "kettleQuery");
                continue;
            }
            builder.useProperty(null, cdaPropName);
        }
    }

    private void readCPKDataSourceComponent(DataSourceComponentType.Builder builder, JXPathContext jctx) {
        builder.useProperty(null, "stepName").useProperty(null, "kettleOutput").addAttribute("pluginId", (String)jctx.getValue("metadata/pluginId")).addAttribute("endpoint", (String)jctx.getValue("metadata/endpoint"));
    }

    private List<String> getCDAPropertyNames(JXPathContext jctx) {
        Map dataaccess;
        ArrayList<String> props = new ArrayList<String>();
        Map connection = (Map)jctx.getValue("definition/connection");
        if (connection != null) {
            props.addAll(connection.keySet());
        }
        if ((dataaccess = (Map)jctx.getValue("definition/dataaccess")) != null) {
            props.addAll(dataaccess.keySet());
        }
        return props;
    }

    private boolean isKettleOverX(String label) {
        return "kettle over kettleTransFromFile".equalsIgnoreCase(label);
    }
}

