/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.writer.cderunjs;

import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.LabeledValue;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.writer.cderunjs.CdeRunJsHelper;
import pt.webdetails.cdf.dd.util.JsonUtils;

public class CdeRunJsPropertyTypeWriter
extends JsWriterAbstract
implements IThingWriter {
    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        String camelName;
        PropertyType prop = (PropertyType)t;
        StringBuilder out = (StringBuilder)output;
        this.writeValuesListInputTypeRenderer(out, prop);
        String fullName = camelName = prop.getCamelName();
        ComponentType owner = prop.getOwner();
        if (owner != null) {
            String modelId = CdeRunJsHelper.getComponentTypeModelId(owner);
            fullName = modelId + "_" + fullName;
        }
        String propVarName = prop.getName() + "Property";
        out.append(CdeConstants.Writer.NEWLINE);
        out.append("var ").append(propVarName).append(" = BasePropertyType.extend({");
        out.append(CdeConstants.Writer.NEWLINE);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "type", JsonUtils.toJsString(fullName), "  ", true);
        CdeRunJsPropertyTypeWriter.addCommaAndLineSep(out);
        out.append("  ").append("stub: {").append(CdeConstants.Writer.NEWLINE);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "name", JsonUtils.toJsString(camelName), "    ", true);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "value", prop.getDefaultValue(), "    ", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "description", JsonUtils.toJsString(prop.getLabel()), "    ", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "tooltip", JsonUtils.toJsString(prop.getTooltip()), "    ", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "type", JsonUtils.toJsString(prop.getInputType()), "    ", false);
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "order", String.valueOf(prop.getOrder()), "    ", false);
        String cat = prop.getCategory();
        if (!"advanced".equals(cat)) {
            cat = "";
        }
        CdeRunJsPropertyTypeWriter.addJsProperty(out, "classType", JsonUtils.toJsString(cat == null ? "" : cat), "    ", false);
        out.append(CdeConstants.Writer.NEWLINE).append("  ").append("}").append(CdeConstants.Writer.NEWLINE).append("});").append(CdeConstants.Writer.NEWLINE);
        out.append("PropertiesManager.register(new ").append(propVarName).append("());").append(CdeConstants.Writer.NEWLINE);
    }

    private void writeValuesListInputTypeRenderer(StringBuilder out, PropertyType prop) {
        String valuesSource = prop.getPossibleValuesSource();
        if (valuesSource != null || prop.getPossibleValueCount() > 0) {
            String rendererName = prop.getInputType() + "Renderer";
            out.append(CdeConstants.Writer.NEWLINE).append("var ").append(rendererName).append(" = ").append(prop.getAttribute("BaseRenderer").getValue()).append(".extend({").append(CdeConstants.Writer.NEWLINE).append("  ").append("selectData: ");
            if (valuesSource != null) {
                out.append(CdeConstants.Writer.NEWLINE).append("    ").append(valuesSource).append(CdeConstants.Writer.NEWLINE);
            } else {
                out.append("{").append(CdeConstants.Writer.NEWLINE);
                boolean isFirst = true;
                for (LabeledValue labeledValue : prop.getPossibleValues()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        CdeRunJsPropertyTypeWriter.addCommaAndLineSep(out);
                    }
                    out.append("    ").append(JsonUtils.toJsString(labeledValue.getValue())).append(": ").append(JsonUtils.toJsString(labeledValue.getLabel()));
                }
                out.append(CdeConstants.Writer.NEWLINE).append("  ").append("}").append(CdeConstants.Writer.NEWLINE);
            }
            out.append("});").append(CdeConstants.Writer.NEWLINE);
        }
    }
}

