/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta.writer.cderunjs.amd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.PropertyType;

public class CdeRunJsModelWriter
extends JsWriterAbstract
implements IThingWriter {
    protected static final Log _logger = LogFactory.getLog(CdeRunJsModelWriter.class);

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        ThingWriteException ex2;
        MetaModel model = (MetaModel)t;
        StringBuilder out = (StringBuilder)output;
        IThingWriterFactory factory = context.getFactory();
        assert (factory != null);
        for (PropertyType prop : model.getPropertyTypes()) {
            IThingWriter propWriter;
            try {
                propWriter = factory.getWriter(prop);
                assert (propWriter != null);
            }
            catch (UnsupportedThingException ex) {
                ex2 = new ThingWriteException(ex);
                if (context.getBreakOnError()) {
                    throw ex2;
                }
                _logger.error((Object)ex2);
                continue;
            }
            propWriter.write(out, context, prop);
        }
        for (ComponentType comp : model.getComponentTypes()) {
            IThingWriter compWriter;
            if (!comp.supportsAMD()) continue;
            try {
                compWriter = factory.getWriter(comp);
                assert (compWriter != null);
            }
            catch (UnsupportedThingException ex) {
                ex2 = new ThingWriteException(ex);
                if (context.getBreakOnError()) {
                    throw ex2;
                }
                _logger.error((Object)ex2);
                continue;
            }
            compWriter.write(out, context, comp);
        }
    }
}

