/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.render.RenderException;
import pt.webdetails.cdf.dd.render.Renderer;
import pt.webdetails.cdf.dd.render.layout.Render;
import pt.webdetails.cdf.dd.util.XPathUtils;

public class RenderLayout
extends Renderer {
    private static final String RESOURCES = "and type!='LayoutResourceFile' and type!='LayoutResourceCode'";
    boolean includeResources;

    public RenderLayout(JXPathContext doc, CdfRunJsDashboardWriteContext context) {
        super(doc, context);
        this.includeResources = true;
    }

    public RenderLayout(JXPathContext doc, CdfRunJsDashboardWriteContext context, boolean includeResources) {
        super(doc, context);
        this.includeResources = includeResources;
    }

    @Override
    public String render(String alias) throws Exception {
        try {
            String filter = MessageFormat.format("/layout/rows[parent=''{0}'' {1}]", "UnIqEiD", !this.includeResources ? RESOURCES : "");
            Iterator layoutRows = this.doc.iteratePointers(filter);
            StringBuffer layout = new StringBuffer();
            if (this.getContext().getDashboard().getWcdf().isRequire()) {
                layout.append(NEWLINE).append(this.getIndent(2)).append("<div class='").append(StringUtils.isEmpty((String)alias) ? "container'>" : alias + "_container'>");
                this.renderRows(this.doc, layoutRows, null, alias, layout, -1);
                layout.append(NEWLINE).append(this.getIndent(2)).append("</div>");
            } else {
                layout.append(NEWLINE).append(this.getIndent(2)).append("<div class='container'>");
                this.renderRows(this.doc, layoutRows, this.getWidgets(alias), alias, layout, 4);
                layout.append(NEWLINE).append(this.getIndent(2)).append("</div>");
            }
            return layout.toString();
        }
        catch (RenderException ex) {
            return ex.getMessage();
        }
    }

    private void renderRows(JXPathContext doc, Iterator nodeIterator, Map<String, CdfRunJsDashboardWriteResult> widgetsByContainerId, String alias, StringBuffer layout, int indent) throws Exception {
        while (nodeIterator.hasNext()) {
            CdfRunJsDashboardWriteResult widgetResult;
            Pointer pointer = (Pointer)nodeIterator.next();
            JXPathContext context = doc.getRelativeContext(pointer);
            String rowId = (String)context.getValue("id");
            String rowName = XPathUtils.getStringValue(context, "properties[name='name']/value");
            Render renderer = (Render)this.getRender(context);
            renderer.processProperties();
            renderer.aliasId(alias);
            if (indent > -1) {
                layout.append(NEWLINE).append(this.getIndent(indent)).append(renderer.renderStart());
                if (widgetsByContainerId != null && widgetsByContainerId.containsKey(rowName)) {
                    widgetResult = widgetsByContainerId.get(rowName);
                    layout.append(widgetResult.getLayout());
                } else {
                    this.renderRows(context, context.iteratePointers(MessageFormat.format("/layout/rows[parent=''{0}'' {1}]", rowId, "")), widgetsByContainerId, alias, layout, indent + 2);
                }
                layout.append(NEWLINE).append(this.getIndent(indent)).append(renderer.renderClose());
                continue;
            }
            layout.append(renderer.renderStart());
            if (widgetsByContainerId != null && widgetsByContainerId.containsKey(rowName)) {
                widgetResult = widgetsByContainerId.get(rowName);
                layout.append(widgetResult.getLayout());
            } else {
                this.renderRows(context, context.iteratePointers(MessageFormat.format("/layout/rows[parent=''{0}'' {1}]", rowId, "")), widgetsByContainerId, alias, layout, -1);
            }
            layout.append(renderer.renderClose());
        }
    }

    @Override
    protected String getRenderClassName(String type) {
        return "pt.webdetails.cdf.dd.render.layout." + type.replace("Layout", "") + "Render";
    }
}

