/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render;

import java.text.MessageFormat;
import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.render.Renderer;
import pt.webdetails.cdf.dd.render.ResourceMap;
import pt.webdetails.cdf.dd.render.layout.Render;
import pt.webdetails.cdf.dd.render.layout.ResourceCodeRender;
import pt.webdetails.cdf.dd.util.XPathUtils;

public class RenderResources
extends Renderer {
    private static final String RESOURCES = " and (type='LayoutResourceFile' or type='LayoutResourceCode')";
    private static final String PROPERTY_RESOURCE_NAME = "properties[name='name']/value";
    private static final String PROPERTY_RESOURCE_TYPE = "properties[name='resourceType']/value";
    private static final String PROPERTY_RESOURCE_CODE_CONTENT = "properties/value[../name='resourceCode']";
    private static final String PROPERTY_RESOURCE_PATH = "properties/value[../name='resourceFile']";

    public RenderResources(JXPathContext doc, CdfRunJsDashboardWriteContext context) {
        super(doc, context);
    }

    @Override
    public String render(String alias) {
        return "";
    }

    public ResourceMap renderResources(String alias) throws Exception {
        Iterator resourceRows = this.getResourcesRows();
        ResourceMap resources = new ResourceMap();
        while (resourceRows.hasNext()) {
            JXPathContext context = this.getRelativeContext((Pointer)resourceRows.next());
            resources.add(this.getResourceType(context).equals("Javascript") ? ResourceMap.ResourceKind.JAVASCRIPT : ResourceMap.ResourceKind.CSS, context.getValue("type").equals("LayoutResourceFile") ? ResourceMap.ResourceType.FILE : ResourceMap.ResourceType.CODE, this.getResourceName(context), this.getResourcePath(context), this.processResource(context, alias, 4));
        }
        return resources;
    }

    protected Iterator getResourcesRows() {
        return this.doc.iteratePointers(MessageFormat.format("/layout/rows[parent=''{0}'' {1}]", "UnIqEiD", RESOURCES));
    }

    protected JXPathContext getRelativeContext(Pointer p) {
        return this.doc.getRelativeContext(p);
    }

    protected String processResource(JXPathContext context, String alias, int indent) throws Exception {
        StringBuilder buffer = new StringBuilder();
        Render renderer = (Render)this.getRender(context);
        renderer.processProperties();
        renderer.aliasId(alias);
        buffer.append(NEWLINE).append(this.getIndent(indent));
        if (this.getContext().getDashboard().getWcdf().isRequire()) {
            String resourceType = this.getResourceType(context);
            if (renderer instanceof ResourceCodeRender && resourceType.equals("Javascript")) {
                buffer.append(this.getResourceCodeContent(context));
            } else {
                buffer.append(renderer.renderStart());
            }
        } else {
            buffer.append(renderer.renderStart());
        }
        return buffer.toString();
    }

    protected String getResourceName(JXPathContext context) {
        return XPathUtils.getStringValue(context, PROPERTY_RESOURCE_NAME);
    }

    protected String getResourcePath(JXPathContext context) {
        return XPathUtils.getStringValue(context, PROPERTY_RESOURCE_PATH);
    }

    protected String getResourceType(JXPathContext context) {
        return XPathUtils.getStringValue(context, PROPERTY_RESOURCE_TYPE);
    }

    protected String getResourceCodeContent(JXPathContext context) {
        return XPathUtils.getStringValue(context, PROPERTY_RESOURCE_CODE_CONTENT);
    }

    @Override
    protected String getRenderClassName(String type) {
        return "pt.webdetails.cdf.dd.render.layout." + type.replace("Layout", "") + "Render";
    }
}

