/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.DashboardManager;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.Component;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;

public abstract class Renderer {
    protected static final String UNIQUEID = "UnIqEiD";
    protected static final String XPATH_FILTER = "/layout/rows[parent=''{0}'' {1}]";
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final Class<JXPathContext>[] rendererConstructorArgs = new Class[]{JXPathContext.class};
    protected static Log logger = LogFactory.getLog(Renderer.class);
    protected final JXPathContext doc;
    protected final CdfRunJsDashboardWriteContext _context;

    public Renderer(JXPathContext doc, CdfRunJsDashboardWriteContext context) {
        this.doc = doc;
        this._context = context;
    }

    public abstract String render(String var1) throws Exception;

    protected abstract String getRenderClassName(String var1);

    protected final Map<String, CdfRunJsDashboardWriteResult> getWidgets(String aliasPrefix) {
        HashMap<String, CdfRunJsDashboardWriteResult> widgetsByContainerId = new HashMap<String, CdfRunJsDashboardWriteResult>();
        Dashboard dashboard = this.getContext().getDashboard();
        if (dashboard.getRegularCount() > 0) {
            DashboardManager dashMgr = DashboardManager.getInstance();
            CdfRunJsDashboardWriteOptions options = this.getContext().getOptions();
            Iterable<Component> components = dashboard.getRegulars();
            for (Component comp : components) {
                if (!StringUtils.isNotEmpty((String)comp.getName()) || !(comp instanceof WidgetComponent)) continue;
                WidgetComponent widgetComp = (WidgetComponent)comp;
                CdfRunJsDashboardWriteOptions childOptions = options.addAliasPrefix(comp.getName());
                CdfRunJsDashboardWriteResult dashResult = null;
                try {
                    dashResult = dashMgr.getDashboardCdfRunJs(widgetComp.getWcdfPath(), childOptions, this.getContext().isBypassCacheRead());
                }
                catch (ThingWriteException ex) {
                    logger.error((Object)("Could not render widget '" + widgetComp.getWcdfPath() + "'"), (Throwable)ex);
                }
                String containerId = widgetComp.tryGetPropertyValue("htmlObject", "").replaceAll("\\$\\{.*:(.*)\\}", "$1");
                widgetsByContainerId.put(containerId, dashResult);
            }
        }
        return widgetsByContainerId;
    }

    protected Object getRender(JXPathContext context) throws Exception {
        String renderType = null;
        try {
            renderType = (String)context.getValue("type");
            if (!renderType.equals("Label")) {
                Class<JXPathContext> rendererClass = Class.forName(this.getRenderClassName(renderType));
                Constructor<?> constructor = rendererClass.getConstructor(rendererConstructorArgs);
                return constructor.newInstance(context);
            }
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getStackTrace());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getStackTrace());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Class not found: " + renderType));
        }
        return null;
    }

    protected final String getIndent(int indent) {
        switch (indent) {
            case 0: {
                return "";
            }
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
            case 4: {
                return "    ";
            }
            case 8: {
                return "        ";
            }
        }
        StringBuilder identStr = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            identStr.append(" ");
        }
        return identStr.toString();
    }

    public static String aliasName(String aliasPrefix, String name) {
        aliasPrefix = StringUtils.isEmpty((String)aliasPrefix) ? "" : aliasPrefix + "_";
        return aliasPrefix + name;
    }

    public CdfRunJsDashboardWriteContext getContext() {
        return this._context;
    }
}

