/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render.cda;

import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pt.webdetails.cdf.dd.render.cda.CdaElementRenderer;

public class Output
implements CdaElementRenderer {
    private Map<String, Object> definition;
    private JXPathContext context;

    public Output() {
    }

    public Output(JXPathContext context) {
        this.context = context;
    }

    @Override
    public void renderInto(Element dataAccess) throws JSONException {
        String mode;
        JSONArray columns = new JSONArray((String)this.definition.get("value"));
        try {
            mode = this.context.getValue("properties/.[name='outputMode']/value").toString();
        }
        catch (Exception e) {
            mode = "include";
        }
        if (columns.length() == 0) {
            return;
        }
        Document doc = dataAccess.getOwnerDocument();
        Element output = doc.createElement("Output");
        output.setAttribute("mode", mode.toLowerCase());
        dataAccess.appendChild(output);
        StringBuilder indexes = new StringBuilder();
        for (int i = 0; i < columns.length(); ++i) {
            String col = columns.getString(i);
            indexes.append(col);
            if (i + 1 >= columns.length()) continue;
            indexes.append(",");
        }
        output.setAttribute("indexes", indexes.toString());
    }

    @Override
    public void setDefinition(Map<String, Object> definition) {
        this.definition = definition;
    }

    public void setContext(JXPathContext context) {
        this.context = context;
    }
}

