/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render.cda;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pt.webdetails.cdf.dd.render.cda.CdaElementRenderer;

public class Parameters
implements CdaElementRenderer {
    private Map<String, Object> definition;
    private final String NAME_ATTR = "name";
    private final String DEFAULT_ATTR = "default";
    private final String TYPE_ATTR = "type";
    private final String ACCESS_ATTR = "access";
    private final String PATTERN_ATTR = "pattern";
    private final String ELEMENT_NAME = "Parameter";

    @Override
    public void renderInto(Element dataAccess) throws JSONException {
        Document doc = dataAccess.getOwnerDocument();
        Element parameters = doc.createElement("Parameters");
        dataAccess.appendChild(parameters);
        JSONArray params = new JSONArray((String)this.definition.get("value"));
        for (int i = 0; i < params.length(); ++i) {
            JSONArray param = params.getJSONArray(i);
            Element parameter = doc.createElement("Parameter");
            parameter.setAttribute("name", (String)param.get(0));
            parameter.setAttribute("default", (String)param.get(1));
            if (param.length() > 2) {
                parameter.setAttribute("type", (String)param.get(2));
                if (param.length() > 3) {
                    String pattern;
                    String access = (String)param.get(3);
                    if (!StringUtils.isEmpty((String)access)) {
                        parameter.setAttribute("access", access);
                    }
                    if (param.length() > 4 && !StringUtils.isEmpty((String)(pattern = (String)param.get(4)))) {
                        parameter.setAttribute("pattern", pattern);
                    }
                }
            } else {
                parameter.setAttribute("type", "String");
            }
            parameters.appendChild(parameter);
        }
    }

    @Override
    public void setDefinition(Map<String, Object> definition) {
        this.definition = definition;
    }
}

