/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render.layout;

import org.apache.commons.jxpath.JXPathContext;
import org.json.JSONArray;
import org.json.JSONException;
import pt.webdetails.cdf.dd.render.layout.Render;
import pt.webdetails.cdf.dd.util.XPathUtils;

public class FreeFormRender
extends Render {
    private String elementTag;
    private String moreProperties;

    public FreeFormRender(JXPathContext context) {
        super(context);
    }

    @Override
    public void processProperties() {
        this.setElementTag(this.getPropertyString("elementTag"));
        this.setMoreProperties(this.getPropertyString("otherAttributes"));
        this.getPropertyBag().addId(this.getId());
        this.getPropertyBag().addClass(this.getPropertyString("cssClass"));
    }

    @Override
    public String renderStart() throws JSONException {
        String content = "<" + this.elementTag + " " + this.getPropertyBagString();
        content = content + this.buildMoreProperties() + ">";
        return content;
    }

    @Override
    public String renderClose() {
        return "</" + this.elementTag + ">";
    }

    protected String getId() {
        String id = this.getPropertyString("name");
        return id.length() > 0 ? id : XPathUtils.getStringValue(this.getNode(), "id");
    }

    protected String buildMoreProperties() throws JSONException {
        String properties = "";
        String arg = "";
        String value = "";
        JSONArray attrs = new JSONArray(this.getMoreProperties());
        for (int i = 0; i < attrs.length(); ++i) {
            JSONArray insertVal = attrs.getJSONArray(i);
            arg = insertVal.getString(0);
            value = insertVal.getString(1);
            if ((!arg.equals("id") || !this.getPropertyString("name").equals("")) && arg.equals("id")) continue;
            properties = properties + " " + arg + "=" + (value.indexOf("'") != -1 ? "\"" + value + "\"" : "'" + value + "'");
        }
        return properties;
    }

    protected String getMoreProperties() {
        return this.moreProperties;
    }

    protected void setMoreProperties(String properties) {
        this.moreProperties = properties;
    }

    protected void setElementTag(String tag) {
        this.elementTag = tag;
    }
}

