/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.util;

import pt.webdetails.cdf.dd.util.GenericBasicFileFilter;
import pt.webdetails.cpf.repository.api.IBasicFile;

public class GenericFileAndDirectoryFilter
extends GenericBasicFileFilter {
    private String[] directories;
    private FilterType filterType;

    public GenericFileAndDirectoryFilter(String fileName, String[] fileExtensions, String[] directories, FilterType filterType) {
        this(fileName, fileExtensions, true, directories, filterType);
    }

    public GenericFileAndDirectoryFilter(String fileName, String[] fileExtensions, boolean acceptDirectories, String[] directories, FilterType filterType) {
        super(fileName, fileExtensions, acceptDirectories);
        this.setDirectories(directories);
        this.setFilterType(filterType != null ? filterType : FilterType.FILTER_IN);
    }

    public GenericFileAndDirectoryFilter(GenericBasicFileFilter basicFileFilter) {
        super(basicFileFilter.getFileName(), basicFileFilter.getFileExtensions(), basicFileFilter.isAcceptDirectories());
    }

    public GenericFileAndDirectoryFilter(GenericBasicFileFilter basicFileFilter, String[] directories, FilterType filterType) {
        this(basicFileFilter.getFileName(), basicFileFilter.getFileExtensions(), basicFileFilter.isAcceptDirectories(), directories, filterType);
    }

    @Override
    public boolean accept(IBasicFile file) {
        boolean acceptFile = super.accept(file);
        if (acceptFile && this.isAcceptDirectories() && file.isDirectory() && this.directories != null) {
            boolean directoryExists = false;
            for (String directory : this.directories) {
                directoryExists |= file.getFullPath().endsWith(directory);
            }
            if (FilterType.FILTER_IN == this.filterType) {
                acceptFile = directoryExists;
            } else if (FilterType.FILTER_OUT == this.filterType) {
                acceptFile = !directoryExists;
            }
        }
        return acceptFile;
    }

    public String[] getDirectories() {
        return this.directories;
    }

    public void setDirectories(String[] directories) {
        this.directories = directories;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public static enum FilterType {
        FILTER_IN,
        FILTER_OUT;

    }
}

