/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static final int INDENT = 2;

    public static JSONObject readJsonFromInputStream(InputStream input) throws IOException, JSONException {
        String contents = StringUtils.trim((String)IOUtils.toString((InputStream)input, (String)"UTF-8"));
        return new JSONObject(contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildJsonResult(OutputStream out, Boolean success, Object result) throws JSONException {
        JSONObject jsonResult = new JSONObject();
        if (result != null) {
            jsonResult.put("result", result);
        }
        jsonResult.put("status", (Object)success.toString());
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(out);
            pw.print(jsonResult.toString(2));
            pw.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)pw);
    }

    public static String getJsonResult(boolean success, Object result) throws JSONException {
        JSONObject jsonResult = new JSONObject();
        jsonResult.put("status", (Object)Boolean.toString(success));
        if (result != null) {
            jsonResult.put("result", result);
        }
        return jsonResult.toString(2);
    }

    public static String toJsString(String text) {
        String content = text == null ? "" : text.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
        return "\"" + content + "\"";
    }

    public static JXPathContext toJXPathContext(JSONObject json) throws JSONException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            hashMap.put(key, JsonUtils.processValue(json.get(key)));
        }
        return JXPathContext.newContext(hashMap);
    }

    private static Object processValue(Object obj) throws JSONException {
        if (obj instanceof JSONObject) {
            return JsonUtils.processValueAsJSON((JSONObject)obj);
        }
        if (obj instanceof JSONArray) {
            return JsonUtils.processValueAsJSONArray((JSONArray)obj);
        }
        return obj;
    }

    private static Map<String, Object> processValueAsJSON(JSONObject json) throws JSONException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            hashMap.put(key, JsonUtils.processValue(json.get(key)));
        }
        return hashMap;
    }

    private static List<Object> processValueAsJSONArray(JSONArray arr) throws JSONException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < arr.length(); ++i) {
            arrayList.add(JsonUtils.processValue(arr.get(i)));
        }
        return arrayList;
    }
}

