/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pentaho.osgi.platform.plugin.deployer.api.ManifestUpdater;

public class ManifestUpdaterImpl
implements ManifestUpdater {
    private final Map<String, String> imports;
    private final Set<String> exportServices;
    private final Map<Object, Object> entries = new HashMap<Object, Object>();
    private String bundleName;

    public ManifestUpdaterImpl() {
        this.imports = new HashMap<String, String>();
        this.exportServices = new HashSet<String>();
    }

    @Override
    public void setBundleSymbolicName(String name) {
        this.bundleName = name;
    }

    @Override
    public String getBundleSymbolicName() {
        return this.bundleName;
    }

    @Override
    public Map<String, String> getImports() {
        return this.imports;
    }

    @Override
    public Set<String> getExportServices() {
        return this.exportServices;
    }

    @Override
    public void addEntry(Object key, Object value) {
        this.entries.put(key, value.toString());
    }

    @Override
    public void write(Manifest originalManifest, OutputStream outputStream, String name, String symbolicName, String version) throws IOException {
        Manifest newManifest = new Manifest();
        if (originalManifest != null) {
            newManifest = new Manifest(originalManifest);
        }
        Attributes mainAttributes = newManifest.getMainAttributes();
        for (Map.Entry<Object, Object> entry : this.entries.entrySet()) {
            mainAttributes.putValue(entry.getKey().toString(), entry.getValue().toString());
        }
        mainAttributes.putValue("Manifest-Version", "2");
        mainAttributes.putValue("Bundle-ManifestVersion", "2");
        mainAttributes.putValue("Bundle-SymbolicName", this.bundleName != null ? this.bundleName : symbolicName);
        mainAttributes.putValue("Bundle-Name", name);
        mainAttributes.putValue("Bundle-Version", version);
        mainAttributes.putValue("Bundle-PlatformPluginName", symbolicName);
        mainAttributes.putValue("Export-Service", this.join(this.getExportServices(), ","));
        mainAttributes.putValue("Import-Package", this.getImportString());
        mainAttributes.putValue("DynamicImport-Package", "*");
        newManifest.write(outputStream);
    }

    protected String join(Collection<String> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String value : collection) {
            sb.append(value);
            sb.append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    protected String getImportString() {
        HashSet<String> imports = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.getImports().entrySet()) {
            String importString = entry.getKey();
            String version = entry.getValue();
            if (version != null) {
                importString = importString + ";version=\"" + entry.getValue() + "\"";
            }
            imports.add(importString);
        }
        ArrayList<String> importList = new ArrayList<String>(imports);
        Collections.sort(importList);
        return this.join(importList, ",");
    }
}

