/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSProgressIndicator;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTProgressIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    NSBezierPath visiblePath;

    public ProgressBar(Composite composite, int n) {
        super(composite, ProgressBar.checkStyle(n));
    }

    static int checkStyle(int n) {
        return ProgressBar.checkBits(n |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 14;
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            n5 = n3;
            n4 = n5 * 10;
        } else {
            n4 = n3;
            n5 = n4 * 10;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        return new Point(n4, n5);
    }

    @Override
    void createHandle() {
        NSProgressIndicator nSProgressIndicator = (NSProgressIndicator)new SWTProgressIndicator().alloc();
        nSProgressIndicator.init();
        nSProgressIndicator.setUsesThreadedAnimation(false);
        if ((this.style & 0x200) != 0) {
            nSProgressIndicator.setBoundsRotation(-90.0);
        }
        nSProgressIndicator.setIndeterminate((this.style & 2) != 0);
        this.view = nSProgressIndicator;
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.progressIndicatorFont;
    }

    @Override
    void _drawThemeProgressArea(long l, long l2, long l3) {
        NSRect nSRect = this.view.frame();
        if (nSRect.width == 0.0 || nSRect.height == 0.0) {
            return;
        }
        if (this.visiblePath == null) {
            long l4 = this.getVisibleRegion();
            this.visiblePath = this.getPath(l4);
            OS.DisposeRgn(l4);
        }
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        nSGraphicsContext.saveGraphicsState();
        this.visiblePath.setClip();
        super._drawThemeProgressArea(l, l2, l3);
        nSGraphicsContext.restoreGraphicsState();
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).minValue();
    }

    public int getSelection() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).doubleValue();
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = (int)((NSProgressIndicator)this.view).minValue();
        if (n <= n2) {
            return;
        }
        ((NSProgressIndicator)this.view).setMaxValue(n);
        int n3 = (int)((NSProgressIndicator)this.view).doubleValue();
        int n4 = Math.min(n3, n);
        if (n3 != n4) {
            ((NSProgressIndicator)this.view).setDoubleValue(n4);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int n2 = (int)((NSProgressIndicator)this.view).maxValue();
        if (0 > n || n >= n2) {
            return;
        }
        ((NSProgressIndicator)this.view).setMinValue(n);
        int n3 = (int)((NSProgressIndicator)this.view).doubleValue();
        int n4 = Math.max(n3, n);
        if (n3 != n4) {
            ((NSProgressIndicator)this.view).setDoubleValue(n4);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        ((NSProgressIndicator)this.view).setDoubleValue(n);
        this.update(false);
    }

    public void setState(int n) {
        this.checkWidget();
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    @Override
    void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    @Override
    void viewDidMoveToWindow(long l, long l2) {
        if (this.view.window() != null && (this.style & 2) != 0) {
            ((NSProgressIndicator)this.view).startAnimation(null);
        }
    }
}

