/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.Serializable;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSTabView;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTabView;
import org.eclipse.swt.internal.cocoa.SWTTabViewItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    int itemCount;
    boolean ignoreSelect;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        if (n == -1 && this.items.length > 0) {
            NSSize nSSize = ((NSTabView)this.view).minimumSize();
            Rectangle rectangle = this.computeTrim(0, 0, (int)Math.ceil(nSSize.width), 0);
            point.x = Math.max(rectangle.width, point.x);
        }
        return point;
    }

    @Override
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        NSTabView nSTabView = (NSTabView)this.view;
        NSRect nSRect = nSTabView.contentRect();
        n = (int)((double)n - nSRect.x);
        n2 = (int)((double)n2 - nSRect.y);
        NSRect nSRect2 = nSTabView.frame();
        n3 = (int)((double)n3 + Math.ceil(nSRect2.width - nSRect.width));
        n4 = (int)((double)n4 + Math.ceil(nSRect2.height - nSRect.height));
        return super.computeTrim(n, n2, n3, n4);
    }

    @Override
    void createHandle() {
        NSTabView nSTabView = (NSTabView)new SWTTabView().alloc();
        nSTabView.init();
        nSTabView.setDelegate(nSTabView);
        if ((this.style & 0x400) != 0) {
            nSTabView.setTabViewType(2L);
        }
        this.view = nSTabView;
    }

    void createItem(TabItem tabItem, int n) {
        Object object;
        int n2 = this.itemCount;
        if (0 > n || n > n2) {
            this.error(6);
        }
        if (n2 == this.items.length) {
            object = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        System.arraycopy(this.items, n, this.items, n + 1, n2 - n);
        this.items[n] = tabItem;
        ++this.itemCount;
        tabItem.nsItem = object = (NSTabViewItem)new SWTTabViewItem().alloc().init();
        tabItem.createJNIRef();
        tabItem.register();
        ((NSTabView)this.view).insertTabViewItem((NSTabViewItem)object, n);
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.tabViewFont;
    }

    void destroyItem(TabItem tabItem) {
        int n;
        int n2 = this.itemCount;
        for (n = 0; n < n2 && this.items[n] != tabItem; ++n) {
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --n2 - n);
        this.items[n2] = null;
        if (n2 == 0) {
            this.items = new TabItem[4];
        }
        this.itemCount = n2;
        ((NSTabView)this.view).removeTabViewItem(tabItem.nsItem);
    }

    @Override
    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    @Override
    Widget findTooltip(NSPoint nSPoint) {
        NSTabViewItem nSTabViewItem = ((NSTabView)this.view).tabViewItemAtPoint(nSPoint = this.view.convertPoint_fromView_(nSPoint, null));
        if (nSTabViewItem != null) {
            for (int i = 0; i < this.itemCount; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem.nsItem.id != nSTabViewItem.id) continue;
                return tabItem;
            }
        }
        return super.findTooltip(nSPoint);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect nSRect = ((NSTabView)this.view).contentRect();
        int n = Math.max(0, (int)nSRect.x);
        int n2 = Math.max(0, (int)nSRect.y);
        int n3 = Math.max(0, (int)Math.ceil(nSRect.width));
        int n4 = Math.max(0, (int)Math.ceil(nSRect.height));
        return new Rectangle(n, n2, n3, n4);
    }

    public TabItem getItem(int n) {
        this.checkWidget();
        int n2 = this.itemCount;
        if (0 > n || n >= n2) {
            this.error(6);
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        NSTabView nSTabView = (NSTabView)this.view;
        NSTabViewItem nSTabViewItem = nSTabView.tabViewItemAtPoint(nSPoint);
        for (int i = 0; i < this.itemCount; ++i) {
            NSTabViewItem nSTabViewItem2 = this.items[i].nsItem;
            if (!nSTabViewItem2.isEqual(nSTabViewItem)) continue;
            return this.items[i];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = this.itemCount;
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTabViewItem nSTabViewItem = ((NSTabView)this.view).selectedTabViewItem();
        if (nSTabViewItem == null) {
            return -1;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i].nsItem.id != nSTabViewItem.id) continue;
            return i;
        }
        return -1;
    }

    @Override
    float getThemeAlpha() {
        return (this.background != null ? 1.0f : 0.25f) * this.parent.getThemeAlpha();
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            if (this.items[i] != tabItem) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean isTransparent() {
        return true;
    }

    @Override
    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            Serializable serializable;
            int n5;
            Control control = controlArray[i];
            int n6 = this.itemCount;
            for (n5 = 0; n5 < n6 && this.items[n5].control != control; ++n5) {
            }
            if (n5 == n6) {
                serializable = control.getBounds();
                n3 = Math.max(n3, serializable.x + serializable.width);
                n4 = Math.max(n4, serializable.y + serializable.height);
                continue;
            }
            serializable = control.computeSize(n, n2, bl);
            n3 = Math.max(n3, ((Point)serializable).x);
            n4 = Math.max(n4, ((Point)serializable).y);
        }
        return new Point(n3, n4);
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null || tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            TabItem tabItem = this.items[i];
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            for (int i = 0; i < this.itemCount; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null) continue;
                tabItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    void setFont(NSFont nSFont) {
        ((NSTabView)this.view).setFont(nSFont);
        int n = this.getSelectionIndex();
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].updateText(i == n);
        }
    }

    @Override
    void setForeground(double[] dArray) {
        super.setForeground(dArray);
        int n = this.getSelectionIndex();
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].updateText(i == n);
        }
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false, false);
        } else {
            for (int i = tabItemArray.length - 1; i >= 0; --i) {
                int n = this.indexOf(tabItemArray[i]);
                if (n == -1) continue;
                this.setSelection(n, false, false);
            }
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = this.itemCount;
        if (0 > n || n >= n2) {
            return;
        }
        this.setSelection(n, false, false);
    }

    void setSelection(int n, boolean bl, boolean bl2) {
        Control control;
        TabItem tabItem;
        if (0 > n || n >= this.itemCount) {
            return;
        }
        int n2 = this.getSelectionIndex();
        if (!bl2 && n2 == n) {
            return;
        }
        if (n2 != -1 && (tabItem = this.items[n2]) != null && (control = tabItem.control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.ignoreSelect = true;
        ((NSTabView)this.view).selectTabViewItemAtIndex(n);
        this.ignoreSelect = false;
        n = this.getSelectionIndex();
        if (n != -1 && (tabItem = this.items[n]) != null) {
            control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = tabItem;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    @Override
    void setSmallSize() {
        ((NSTabView)this.view).setControlSize(1L);
    }

    @Override
    boolean traversePage(boolean bl) {
        int n = this.getItemCount();
        if (n == 0) {
            return false;
        }
        int n2 = this.getSelectionIndex();
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3 = bl ? 1 : -1;
            n2 = (n2 + n3 + n) % n;
        }
        this.setSelection(n2, true, false);
        return n2 == this.getSelectionIndex();
    }

    @Override
    void tabView_willSelectTabViewItem(long l, long l2, long l3, long l4) {
        if (l4 == 0L) {
            return;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            Widget widget;
            TabItem tabItem = this.items[i];
            if (tabItem.nsItem.id != l4) continue;
            int n = this.getSelectionIndex();
            if (n != -1 && (widget = this.items[n]) != null) {
                Control control;
                if (OS.VERSION >= 4208) {
                    ((TabItem)widget).updateText(false);
                }
                if ((control = ((TabItem)widget).control) != null && !control.isDisposed()) {
                    control.setVisible(false);
                }
            }
            if ((widget = tabItem.control) != null && !widget.isDisposed()) {
                ((Control)widget).setVisible(true);
            }
            if (OS.VERSION < 4208) break;
            tabItem.updateText(true);
            break;
        }
    }

    @Override
    void tabView_didSelectTabViewItem(long l, long l2, long l3, long l4) {
        if (l4 == 0L) {
            return;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            Object object;
            TabItem tabItem = this.items[i];
            Control control = tabItem.control;
            if (control != null && ((NSView)(object = control.topView())).superview() == null) {
                this.contentView().addSubview((NSView)object, -1L, null);
            }
            if (tabItem.nsItem.id != l4 || this.ignoreSelect) continue;
            object = new Event();
            ((Event)object).item = tabItem;
            this.sendSelectionEvent(13, (Event)object, false);
        }
    }
}

