/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.analyticquery;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.AfterInjection;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.analyticquery.AnalyticQuery;
import org.pentaho.di.trans.steps.analyticquery.AnalyticQueryData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="AnalyticQuery", i18nPackageName="org.pentaho.di.trans.steps.analyticquery", name="AnalyticQuery.Name", description="AnalyticQuery.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Statistics")
@InjectionSupported(localizationPrefix="AnalyticQuery.Injection.")
public class AnalyticQueryMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = AnalyticQuery.class;
    public static final int TYPE_FUNCT_LEAD = 0;
    public static final int TYPE_FUNCT_LAG = 1;
    public static final String[] typeGroupCode = new String[]{"LEAD", "LAG"};
    public static final String[] typeGroupLongDesc = new String[]{BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.TypeGroupLongDesc.LEAD", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.TypeGroupLongDesc.LAG", (String[])new String[0])};
    @Injection(name="GROUP_FIELDS")
    private String[] groupField;
    private int number_of_fields;
    @Injection(name="OUTPUT.AGGREGATE_FIELD")
    private String[] aggregateField;
    @Injection(name="OUTPUT.SUBJECT_FIELD")
    private String[] subjectField;
    @Injection(name="OUTPUT.AGGREGATE_TYPE")
    private int[] aggregateType;
    @Injection(name="OUTPUT.VALUE_FIELD")
    private int[] valueField;

    public String[] getAggregateField() {
        return this.aggregateField;
    }

    public void setAggregateField(String[] aggregateField) {
        this.aggregateField = aggregateField;
    }

    public int[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int[] aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public String[] getSubjectField() {
        return this.subjectField;
    }

    public void setSubjectField(String[] subjectField) {
        this.subjectField = subjectField;
    }

    public int[] getValueField() {
        return this.valueField;
    }

    public void setValueField(int[] valueField) {
        this.valueField = valueField;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int sizegroup, int nrfields) {
        this.groupField = new String[sizegroup];
        this.aggregateField = new String[nrfields];
        this.subjectField = new String[nrfields];
        this.aggregateType = new int[nrfields];
        this.valueField = new int[nrfields];
        this.number_of_fields = nrfields;
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fnode;
            int i;
            Node groupn = XMLHandler.getSubNode((Node)stepnode, (String)"group");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int sizegroup = XMLHandler.countNodes((Node)groupn, (String)"field");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(sizegroup, nrfields);
            for (i = 0; i < sizegroup; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)groupn, (String)"field", (int)i);
                this.groupField[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.aggregateField[i] = XMLHandler.getTagValue((Node)fnode, (String)"aggregate");
                this.subjectField[i] = XMLHandler.getTagValue((Node)fnode, (String)"subject");
                this.aggregateType[i] = AnalyticQueryMeta.getType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.valueField[i] = Integer.parseInt(XMLHandler.getTagValue((Node)fnode, (String)"valuefield"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public static final int getType(String desc) {
        int i;
        for (i = 0; i < typeGroupCode.length; ++i) {
            if (!typeGroupCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= typeGroupCode.length) {
            return null;
        }
        return typeGroupCode[i];
    }

    public static final String getTypeDescLong(int i) {
        if (i < 0 || i >= typeGroupLongDesc.length) {
            return null;
        }
        return typeGroupLongDesc[i];
    }

    public void setDefault() {
        int sizegroup = 0;
        int nrfields = 0;
        this.allocate(sizegroup, nrfields);
    }

    public void getFields(RowMetaInterface r, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        RowMeta fields = new RowMeta();
        fields.addRowMeta(r);
        for (int i = 0; i < this.number_of_fields; ++i) {
            int index_of_subject = -1;
            index_of_subject = r.indexOfValue(this.subjectField[i]);
            if (index_of_subject <= -1) {
                StringBuilder sbfieldNames = new StringBuilder();
                String[] fieldNames = r.getFieldNames();
                for (int j = 0; j < fieldNames.length; ++j) {
                    sbfieldNames.append("[" + fieldNames[j] + "]" + (j < fieldNames.length - 1 ? ", " : ""));
                }
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.Exception.SubjectFieldNotFound", (String[])new String[]{this.getParentStepMeta().getName(), this.subjectField[i], sbfieldNames.toString()}));
            }
            ValueMetaInterface vmi = r.getValueMeta(index_of_subject).clone();
            vmi.setOrigin(origin);
            vmi.setName(this.aggregateField[i]);
            fields.addValueMeta(r.size() + i, vmi);
        }
        r.clear();
        r.addRowMeta((RowMetaInterface)fields);
    }

    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(500);
        retval.append("      <group>").append(Const.CR);
        for (i = 0; i < this.groupField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.groupField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </group>").append(Const.CR);
        retval.append("      <fields>").append(Const.CR);
        for (i = 0; i < this.subjectField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"aggregate", (String)this.aggregateField[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"subject", (String)this.subjectField[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"type", (String)AnalyticQueryMeta.getTypeDesc(this.aggregateType[i])));
            retval.append("          ").append(XMLHandler.addTagValue((String)"valuefield", (int)this.valueField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            int groupsize = rep.countNrStepAttributes(id_step, "group_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "aggregate_name");
            this.allocate(groupsize, nrvalues);
            for (i = 0; i < groupsize; ++i) {
                this.groupField[i] = rep.getStepAttributeString(id_step, i, "group_name");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.aggregateField[i] = rep.getStepAttributeString(id_step, i, "aggregate_name");
                this.subjectField[i] = rep.getStepAttributeString(id_step, i, "aggregate_subject");
                this.aggregateType[i] = AnalyticQueryMeta.getType(rep.getStepAttributeString(id_step, i, "aggregate_type"));
                this.valueField[i] = (int)rep.getStepAttributeInteger(id_step, i, "aggregate_value_field");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.groupField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "group_name", this.groupField[i]);
            }
            for (i = 0; i < this.subjectField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_name", this.aggregateField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_subject", this.subjectField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_type", AnalyticQueryMeta.getTypeDesc(this.aggregateType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "aggregate_value_field", (long)this.valueField[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AnalyticQueryMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new AnalyticQuery(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new AnalyticQueryData();
    }

    public int getNumberOfFields() {
        return this.number_of_fields;
    }

    public void setNumberOfFields(int number_of_fields) {
        this.number_of_fields = number_of_fields;
    }

    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.subjectField == null ? -1 : this.subjectField.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] rtn = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.aggregateField});
        this.aggregateField = rtn[0];
        int[][] rtnInt = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.aggregateType, this.valueField});
        this.aggregateType = rtnInt[0];
        this.valueField = rtnInt[1];
    }
}

