/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.exception;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public class KettleMissingPluginsException
extends KettleException {
    private static final long serialVersionUID = -3008319146447259788L;
    private List<PluginDetails> missingPluginDetailsList = new ArrayList<PluginDetails>();

    public KettleMissingPluginsException(String message) {
        super(message);
    }

    public void addMissingPluginDetails(Class<? extends PluginTypeInterface> pluginTypeClass, String pluginId) {
        this.missingPluginDetailsList.add(new PluginDetails(pluginTypeClass, pluginId));
    }

    public List<PluginDetails> getMissingPluginDetailsList() {
        return this.missingPluginDetailsList;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder(super.getMessage());
        message.append(this.getPluginsMessage());
        return message.toString();
    }

    public String getPluginsMessage() {
        StringBuilder message = new StringBuilder();
        for (PluginDetails details : this.missingPluginDetailsList) {
            message.append(Const.CR);
            try {
                PluginTypeInterface pluginType = PluginRegistry.getInstance().getPluginType(details.pluginTypeClass);
                message.append(pluginType.getName());
            }
            catch (Exception e) {
                message.append("UnknownPluginType-").append(details.pluginTypeClass.getName());
            }
            message.append(" : ").append(details.pluginId);
        }
        return message.toString();
    }

    public class PluginDetails {
        public Class<? extends PluginTypeInterface> pluginTypeClass;
        public String pluginId;

        public PluginDetails(Class<? extends PluginTypeInterface> pluginTypeClass, String pluginId) {
            this.pluginTypeClass = pluginTypeClass;
            this.pluginId = pluginId;
        }
    }
}

