/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.kettle.repository.locator.impl.platform;

import java.util.function.Function;
import java.util.function.Supplier;
import org.pentaho.di.repository.Repository;
import org.pentaho.osgi.kettle.repository.locator.api.KettleRepositoryProvider;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoSessionHolderRepositoryProvider
implements KettleRepositoryProvider {
    public static final String REGION = "pdi-repository-cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(PentahoSessionHolderRepositoryProvider.class);
    private final Supplier<IPentahoSession> pentahoSessionSupplier;
    private final Function<IPentahoSession, ICacheManager> cacheManagerFunction;

    public PentahoSessionHolderRepositoryProvider() {
        this(PentahoSessionHolder::getSession, PentahoSystem::getCacheManager);
    }

    public PentahoSessionHolderRepositoryProvider(Supplier<IPentahoSession> pentahoSessionSupplier, Function<IPentahoSession, ICacheManager> cacheManagerFunction) {
        this.pentahoSessionSupplier = pentahoSessionSupplier;
        this.cacheManagerFunction = cacheManagerFunction;
    }

    public Repository getRepository() {
        String sessionName;
        IPentahoSession session = this.pentahoSessionSupplier.get();
        if (session == null) {
            LOGGER.debug("No active Pentaho Session, attempting to load PDI repository unauthenticated.");
            return null;
        }
        ICacheManager cacheManager = this.cacheManagerFunction.apply(session);
        Repository repository = (Repository)cacheManager.getFromRegionCache(REGION, (Object)(sessionName = session.getName()));
        if (repository == null) {
            LOGGER.debug("Repository not cached for user: " + sessionName + ".");
            return null;
        }
        return repository;
    }
}

