/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.sla;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.sla.SLAJobEventXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.util.LogUtils;

public class SLACoordActionJobEventXCommand
extends SLAJobEventXCommand {
    CoordinatorActionBean ca;
    WorkflowJobBean wf;

    public SLACoordActionJobEventXCommand(SLACalcStatus slaCalc, long lockTimeOut) {
        super(slaCalc, lockTimeOut);
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.ca = CoordActionQueryExecutor.getInstance().get(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION_FOR_SLA, this.slaCalc.getId());
            if (this.ca.getExternalId() != null) {
                this.wf = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_FOR_SLA, this.ca.getExternalId());
            }
            LogUtils.setLogInfo(this.ca);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    protected void updateJobInfo() {
        if (this.ca.isTerminalStatus()) {
            this.setEnded(true);
            this.setEndMiss(this.ca.isTerminalWithFailure());
            this.slaCalc.setActualEnd(this.ca.getLastModifiedTime());
            if (this.wf != null) {
                if (this.wf.getEndTime() != null) {
                    if (this.slaCalc.getExpectedEnd() != null && this.wf.getEndTime().getTime() > this.slaCalc.getExpectedEnd().getTime()) {
                        this.setEndMiss(true);
                    }
                    this.slaCalc.setActualEnd(this.wf.getEndTime());
                }
                this.slaCalc.setActualStart(this.wf.getStartTime());
            }
        } else if (this.wf != null) {
            this.slaCalc.setActualStart(this.wf.getStartTime());
        }
        this.slaCalc.setJobStatus(this.ca.getStatusStr());
    }
}

